package com.elitescloud.cloudt.tims.sso;

import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.security.PrivateKey;

/**
 * 单点登录配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(TimsSsoProperties.class)
@ConditionalOnProperty(prefix = TimsSsoProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@Slf4j
class TimsSsoAutoConfiguration {

    private final TimsSsoProperties timsSsoProperties;

    public TimsSsoAutoConfiguration(TimsSsoProperties timsSsoProperties) {
        this.timsSsoProperties = timsSsoProperties;
        log.info("启用Tims SSO:{}", timsSsoProperties.getServerAddr());
    }

    @Bean
    public SsoSdkClient ssoSdkClient(KeyProperties keyProperties) {
        PrivateKey privateKey = null;
        try {
            privateKey = this.buildPrivateKey(keyProperties);
        } catch (Exception e) {
            throw new IllegalStateException("解析私钥异常：", e);
        }

        var instance = SsoSdkClient.getInstance();
        instance.setSsoProperties(timsSsoProperties);
        instance.setPrivateKey(privateKey);
        return instance;
    }

    private PrivateKey buildPrivateKey(KeyProperties keyProperties) throws Exception {
        var ks = keyProperties.getKeyStore();
        var keystore = JwtUtil.loadKeystore(ks.getLocation(), ks.getType(), ks.getPassword(), ks.getAlias(), ks.getSecret());
        return (PrivateKey) keystore.getKey(ks.getAlias(), ks.getPassword().toCharArray());
    }
}
