package com.elitescloud.cloudt.tims.sso.params;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * SSO登录参数.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/27
 */
@Data
public class TimsSsoLoginDTO implements Serializable {
    private static final long serialVersionUID = -2440449859489681935L;

    /**
     * 用户名
     */
    @NotBlank(message = "用户名为空")
    private String username;

    /**
     * 密码
     */
    @NotBlank(message = "密码为空")
    private String password;

    /**
     * 品牌编号
     */
    private String brandCode;
}
