/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tims.sso;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.sdk.util.ObjectMapperFactory;
import com.elitescloud.cloudt.authorization.sdk.util.RestTemplateFactory;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.tims.sso.TimsSsoProperties;
import com.elitescloud.cloudt.tims.sso.params.TimsSsoLoginDTO;
import com.elitescloud.cloudt.tims.sso.params.TimsSsoResetPwdDTO;
import com.elitescloud.cloudt.tims.sso.params.TimsSsoResult;
import com.elitescloud.cloudt.tims.sso.params.TimsSsoUserDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.net.URI;
import java.security.Key;
import java.security.PrivateKey;
import java.time.Duration;
import java.util.Date;
import java.util.Objects;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class SsoSdkClient
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SsoSdkClient.class);
    private TimsSsoProperties ssoProperties;
    private PrivateKey privateKey;
    private final RestTemplate restTemplate = RestTemplateFactory.instance(builder -> builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{new AuthorizationInterceptor(() -> this.ssoProperties.getTokenTtl(), () -> this.ssoProperties.getAppId(), () -> this.privateKey)}));
    private final ObjectMapper objectMapper = ObjectMapperFactory.instance();
    private static SsoSdkClient instance;

    public void afterPropertiesSet() throws Exception {
        org.springframework.util.Assert.hasText((String)this.ssoProperties.getServerAddr(), (String)"SSO\u670d\u52a1\u7684\u5730\u5740\u672a\u914d\u7f6e");
        org.springframework.util.Assert.hasText((String)this.ssoProperties.getBrandCode(), (String)"SSO\u7684\u54c1\u724c\u7f16\u53f7\u672a\u914d\u7f6e");
        org.springframework.util.Assert.notNull((Object)this.privateKey, (String)"\u79c1\u94a5\u4e3a\u7a7a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SsoSdkClient getInstance() {
        if (instance != null) return instance;
        Class<SsoSdkClient> clazz = SsoSdkClient.class;
        synchronized (SsoSdkClient.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new SsoSdkClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SsoSdkClient() {
    }

    public String addUser(@NotNull TimsSsoUserDTO user) {
        this.checkUser(user);
        if (log.isDebugEnabled()) {
            log.debug("[SSO]\u540c\u6b65\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)this.obj2json(user));
        }
        TimsSsoResult result = this.exchange("/open/user", HttpMethod.POST, new HttpEntity((Object)user), new ParameterizedTypeReference<TimsSsoResult>(){}, new String[0]);
        log.info("[SSO]\u540c\u6b65\u7528\u6237\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)result);
        if (Objects.equals(result.getCode(), 404)) {
            throw new BusinessException("\u521b\u5efa\u5931\u8d25\uff1a\u8be5\u5458\u5de5\u7f16\u7801\u5728SSO\u4e2d\u4e0d\u5b58\u5728");
        }
        Integer code = result.getCode();
        if (code != null && (code == 200 || code == 422) && CharSequenceUtil.isNotBlank((CharSequence)result.getData())) {
            return result.getData();
        }
        return result.getDataSafely(errCode -> {
            String prefix = "\u5411SSO\u540c\u6b65\u8d26\u53f7\u4fe1\u606f\u5931\u8d25";
            if (errCode == 422) {
                return prefix + ":" + (StringUtils.hasText((String)user.getPhonenumber()) ? "\u624b\u673a\u53f7\u5df2\u5b58\u5728" : "\u8d26\u53f7\u5df2\u5b58\u5728");
            }
            return prefix;
        });
    }

    public String tokenByLogin(@NotNull TimsSsoLoginDTO loginDTO) {
        org.springframework.util.Assert.hasText((String)loginDTO.getUsername(), (String)"\u7528\u6237\u540d\u4e3a\u7a7a");
        org.springframework.util.Assert.hasText((String)loginDTO.getPassword(), (String)"\u5bc6\u7801\u4e3a\u7a7a");
        loginDTO.setBrandCode(this.ssoProperties.getBrandCode());
        if (log.isDebugEnabled()) {
            log.debug("[SSO]\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff1a{}", (Object)this.obj2json(loginDTO));
        }
        TimsSsoResult result = this.exchange("/open/authentication/login", HttpMethod.POST, new HttpEntity((Object)loginDTO), new ParameterizedTypeReference<TimsSsoResult>(){}, new String[0]);
        log.info("[SSO]\u7528\u6237\u767b\u5f55\u7ed3\u679c\uff1a{}", (Object)result);
        if (Objects.equals(result.getCode(), 403)) {
            log.warn("\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b\uff0c\u8d26\u53f7\uff1a{}", (Object)loginDTO.getUsername());
            return null;
        }
        String token = result.getDataSafely(errCode -> {
            if (errCode == 401) {
                return "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";
            }
            return "SSO\u8ba4\u8bc1\u5931\u8d25";
        });
        if (CharSequenceUtil.startWithIgnoreCase((CharSequence)token, (CharSequence)"Bearer")) {
            token = token.substring("Bearer".length());
        }
        return token.trim();
    }

    public boolean tokenByRenew(@NotBlank String token) {
        org.springframework.util.Assert.hasText((String)token, (String)"token\u4e3a\u7a7a");
        if (!CharSequenceUtil.startWithIgnoreCase((CharSequence)token, (CharSequence)"Bearer")) {
            token = "Bearer " + (String)token;
        }
        log.info("[SSO]token\u7eed\u671f\uff1a{}", token);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", (String)token);
        TimsSsoResult result = this.exchange("/open/user/tokenRenew", HttpMethod.GET, new HttpEntity((MultiValueMap)headers), new ParameterizedTypeReference<TimsSsoResult>(){}, new String[0]);
        log.info("[SSO]token\u7eed\u671f\u7ed3\u679c\uff1a{}", (Object)result);
        return result.isSuccess();
    }

    public boolean resetPassword(@NotNull TimsSsoResetPwdDTO resetPwdDTO) {
        this.checkRestPwd(resetPwdDTO);
        if (log.isDebugEnabled()) {
            log.debug("[SSO]\u91cd\u7f6e\u5bc6\u7801\u4fe1\u606f\uff1a{}", (Object)this.obj2json(resetPwdDTO));
        }
        TimsSsoResult result = this.exchange("/open/user/resetPw", HttpMethod.PUT, new HttpEntity((Object)resetPwdDTO), new ParameterizedTypeReference<TimsSsoResult>(){}, new String[0]);
        log.info("[SSO]\u91cd\u7f6e\u5bc6\u7801\u7ed3\u679c\uff1a{}", (Object)result);
        return result.isSuccess();
    }

    void setSsoProperties(TimsSsoProperties ssoProperties) {
        SsoSdkClient.instance.ssoProperties = ssoProperties;
        org.springframework.util.Assert.hasText((String)ssoProperties.getServerAddr(), (String)"SSO\u670d\u52a1\u7684\u5730\u5740\u672a\u914d\u7f6e");
        org.springframework.util.Assert.hasText((String)ssoProperties.getBrandCode(), (String)"SSO\u7684\u54c1\u724c\u7f16\u53f7\u672a\u914d\u7f6e");
    }

    void setPrivateKey(PrivateKey privateKey) {
        SsoSdkClient.instance.privateKey = privateKey;
        org.springframework.util.Assert.notNull((Object)privateKey, (String)"\u79c1\u94a5\u4e3a\u7a7a");
    }

    private void checkUser(TimsSsoUserDTO user) {
        org.springframework.util.Assert.notNull((Object)user, (String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        org.springframework.util.Assert.hasText((String)user.getUserType(), (String)"\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a");
        if ("1".equals(user.getUserType())) {
            org.springframework.util.Assert.hasText((String)user.getEmployeeCode(), (String)"\u5458\u5de5\u53f7\u4e3a\u7a7a");
        } else if ("6".equals(user.getUserType())) {
            org.springframework.util.Assert.hasText((String)user.getPhonenumber(), (String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
            org.springframework.util.Assert.hasText((String)user.getUsername(), (String)"\u7528\u6237\u540d\u4e3a\u7a7a");
            org.springframework.util.Assert.hasText((String)user.getEmail(), (String)"\u90ae\u7bb1\u4e3a\u7a7a");
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b\uff1a" + user.getUserType());
        }
        org.springframework.util.Assert.hasText((String)user.getPassword(), (String)"\u5411SSO\u540c\u6b65\u8d26\u53f7\u65f6\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        user.setBrandCode(this.ssoProperties.getBrandCode());
    }

    private void checkRestPwd(TimsSsoResetPwdDTO resetPwdDTO) {
        org.springframework.util.Assert.notNull((Object)resetPwdDTO, (String)"\u91cd\u7f6e\u5bc6\u7801\u4fe1\u606f\u4e3a\u7a7a");
        org.springframework.util.Assert.hasText((String)resetPwdDTO.getUsername(), (String)"\u7528\u6237\u540d\u4e3a\u7a7a");
        org.springframework.util.Assert.hasText((String)resetPwdDTO.getOldPassword(), (String)"\u65e7\u5bc6\u7801\u4e3a\u7a7a");
        org.springframework.util.Assert.hasText((String)resetPwdDTO.getNewPassword(), (String)"\u65b0\u5bc6\u7801\u4e3a\u7a7a");
        resetPwdDTO.setBrandCode(this.ssoProperties.getBrandCode());
    }

    private <T> T exchange(@NotNull String uri, @NotNull HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> responseType, String ... uriParameters) {
        org.springframework.util.Assert.notNull((Object)this.ssoProperties, (String)"SSO\u914d\u7f6e\u5c1a\u672a\u521d\u59cb\u5316");
        String url = this.buildURI(uri, uriParameters).toString();
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, httpMethod, httpEntity, responseType, new Object[0]);
        }
        catch (Throwable var8) {
            log.error("[SSO]{}\u8c03\u7528\u5931\u8d25\uff1a", (Object)url, (Object)var8);
            throw new IllegalStateException("\u8fdc\u7a0b\u670d\u52a1\u5668\u5f02\u5e38", var8);
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            log.error("[SSO]\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)url, (Object)response);
            throw new BusinessException("\u8c03\u7528SSO\u670d\u52a1\u5931\u8d25\uff1a" + response.getStatusCodeValue());
        }
        log.info("[SSO]\u63a5\u53e3{}\u8c03\u7528\u6210\u529f", (Object)url);
        return (T)response.getBody();
    }

    private String obj2json(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isPrimitive()) {
            return object.toString();
        }
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u8f6cjson\u5f02\u5e38", e);
        }
    }

    private URI buildURI(String uri, String ... queryParams) {
        org.springframework.util.Assert.state((boolean)StringUtils.hasText((String)uri), (String)"\u8c03\u7528\u63a5\u53e3\u8def\u5f84\u4e3a\u7a7a");
        org.springframework.util.Assert.state((boolean)StringUtils.hasText((String)this.ssoProperties.getServerAddr()), (String)"SSO\u670d\u52a1\u5668\u5730\u5740\u4e3a\u7a7a");
        return UriComponentsBuilder.fromHttpUrl((String)this.ssoProperties.getServerAddr()).path(uri).build((Object[])queryParams);
    }

    static class AuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final Supplier<Duration> tokenTtlSupplier;
        private final Supplier<String> appIdSupplier;
        private final Supplier<PrivateKey> privateKeySupplier;

        public AuthorizationInterceptor(Supplier<Duration> tokenTtlSupplier, Supplier<String> appIdSupplier, Supplier<PrivateKey> privateKeySupplier) {
            this.tokenTtlSupplier = tokenTtlSupplier;
            this.appIdSupplier = appIdSupplier;
            this.privateKeySupplier = privateKeySupplier;
        }

        @NonNull
        public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders headers = request.getHeaders();
            String token = this.generateToken();
            log.info("gateway token\uff1a{}", (Object)token);
            headers.add("TimsGateWayAuthorization", token);
            headers.add("TimsGateWayAppId", this.appIdSupplier.get());
            return execution.execute(request, body);
        }

        private String generateToken() {
            JwtBuilder jwtBuilder = Jwts.builder().claim("TimsGateWayAppId", (Object)Assert.notBlank((CharSequence)this.appIdSupplier.get(), (String)"AppId\u4e3a\u7a7a", (Object[])new Object[0]));
            Duration tokenTtl = this.tokenTtlSupplier.get();
            if (tokenTtl != null) {
                jwtBuilder.setExpiration(new Date(System.currentTimeMillis() + tokenTtl.toMillis()));
            }
            return jwtBuilder.signWith(SignatureAlgorithm.RS256, (Key)this.privateKeySupplier.get()).compact();
        }
    }
}

