/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tims.sso;

import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.tims.sso.SsoSdkClient;
import com.elitescloud.cloudt.tims.sso.TimsSsoProperties;
import java.security.KeyStore;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TimsSsoProperties.class})
@ConditionalOnProperty(prefix="elitesland.tims.sso", name={"enabled"}, havingValue="true", matchIfMissing=true)
class TimsSsoAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TimsSsoAutoConfiguration.class);
    private final TimsSsoProperties timsSsoProperties;

    public TimsSsoAutoConfiguration(TimsSsoProperties timsSsoProperties) {
        this.timsSsoProperties = timsSsoProperties;
        log.info("\u542f\u7528Tims SSO:{}", (Object)timsSsoProperties.getServerAddr());
    }

    @Bean
    public SsoSdkClient ssoSdkClient(KeyProperties keyProperties) {
        PrivateKey privateKey = null;
        try {
            privateKey = this.buildPrivateKey(keyProperties);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u89e3\u6790\u79c1\u94a5\u5f02\u5e38\uff1a", e);
        }
        SsoSdkClient instance = SsoSdkClient.getInstance();
        instance.setSsoProperties(this.timsSsoProperties);
        instance.setPrivateKey(privateKey);
        return instance;
    }

    private PrivateKey buildPrivateKey(KeyProperties keyProperties) throws Exception {
        KeyProperties.KeyStore ks = keyProperties.getKeyStore();
        KeyStore keystore = JwtUtil.loadKeystore((Resource)ks.getLocation(), (String)ks.getType(), (String)ks.getPassword(), (String)ks.getAlias(), (String)ks.getSecret());
        return (PrivateKey)keystore.getKey(ks.getAlias(), ks.getPassword().toCharArray());
    }
}

