package com.elitescloud.cloudt.tims.sso;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 单点登录配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(TimsSsoProperties.class)
@ConditionalOnProperty(prefix = TimsSsoProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@Slf4j
class TimsSsoAutoConfiguration {

    private final TimsSsoProperties timsSsoProperties;

    public TimsSsoAutoConfiguration(TimsSsoProperties timsSsoProperties) {
        this.timsSsoProperties = timsSsoProperties;
        log.info("启用Tims SSO:{}", timsSsoProperties.getServerAddr());
    }

    @Bean
    public SsoSdkClient ssoSdkClient() {
        var instance = SsoSdkClient.getInstance();
        instance.setSsoProperties(timsSsoProperties);
        return instance;
    }
}
