package com.elitescloud.cloudt.tims.sso.params;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * Sso重置密码.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
@Data
public class TimsSsoResetPwdDTO implements Serializable {
    private static final long serialVersionUID = -3187260694768283274L;

    /**
     * 账号类型
     * <p>
     * headQuarters - 总部员工 partner - 加盟商员工
     */
    @NotBlank(message = "账号类型为空")
    private String userType;

    /**
     * 用户名
     * <p>
     * 总部员工账号传员工邮箱，加盟商账号传username
     */
    @NotBlank(message = "用户名为空")
    private String username;

    /**
     * 品牌编号
     */
    private String brandCode;

    /**
     * 旧密码
     */
    @NotBlank(message = "旧密码为空")
    private String oldPassword;

    /**
     * 新密码
     */
    @NotBlank(message = "新密码为空")
    private String newPassword;
}
