package com.elitescloud.cloudt.tims.sso.params;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.tims.sso.common.TimsSsoConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.function.Function;

/**
 * sso返回结果.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/26
 */
@Data
public class TimsSsoResult implements Serializable {
    private static final long serialVersionUID = 5987148111928378182L;

    /**
     * 响应码
     */
    private Integer code;

    /**
     * 信息
     */
    private String msg;

    /**
     * 数据
     */
    private String data;

    public String getDataSafely(String defMsg) {
        return this.getDataSafely(c -> defMsg);
    }

    public String getDataSafely(Function<Integer, String> defMsg) {
        if (code == null || code != TimsSsoConstant.CODE_SUCCESS) {
            throw new BusinessException(CharSequenceUtil.blankToDefault(msg, defMsg.apply(code)));
        }
        return data;
    }

    public boolean isSuccess() {
        return code != null && code == TimsSsoConstant.CODE_SUCCESS;
    }
}
