/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.tims.sso;

import com.elitescloud.cloudt.tims.sso.SsoSdkClient;
import com.elitescloud.cloudt.tims.sso.TimsSsoProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TimsSsoProperties.class})
@ConditionalOnProperty(prefix="elitesland.tims.sso", name={"enabled"}, havingValue="true", matchIfMissing=true)
class TimsSsoAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TimsSsoAutoConfiguration.class);
    private final TimsSsoProperties timsSsoProperties;

    public TimsSsoAutoConfiguration(TimsSsoProperties timsSsoProperties) {
        this.timsSsoProperties = timsSsoProperties;
        log.info("\u542f\u7528Tims SSO:{}", (Object)timsSsoProperties.getServerAddr());
    }

    @Bean
    public SsoSdkClient ssoSdkClient() {
        SsoSdkClient instance = SsoSdkClient.getInstance();
        instance.setSsoProperties(this.timsSsoProperties);
        return instance;
    }
}

