package com.elitescloud.cloudt.authorization.api.provider.cas.controller;

import com.elitescloud.cloudt.authorization.api.provider.cas.model.AuthorizeSettingVO;
import com.elitescloud.cloudt.authorization.api.provider.cas.support.CasLoginSupportProvider;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * OAuth2登录支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/12
 */
@ResponseBody
@RequestMapping(value = "/oauth2/login/cas", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(tags = {"统一身份认证"})
public class CasLoginSupportController {
    private final CasLoginSupportProvider loginSupportProvider;

    public CasLoginSupportController(CasLoginSupportProvider loginSupportProvider) {
        this.loginSupportProvider = loginSupportProvider;
    }

    @ApiOperation(value = "获取认证设置")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "redirectUrl", value = "认证成功后返回至前端的url路径", required = true),
            @ApiImplicitParam(name = "state", value = "自定义参数"),
    })
    @GetMapping(value = "/setting")
    public ApiResult<AuthorizeSettingVO> getSetting(@NotBlank(message = "重定向路径为空") @RequestParam(value = "redirectUrl") String redirectUrl,
                                                    @RequestParam(value = "state", required = false) String state,
                                                    HttpServletRequest request,
                                                    HttpServletResponse response) {
        return loginSupportProvider.getSetting(response, redirectUrl, state);
    }

    @ApiOperation(value = "授权码换取token")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "授权码", required = true),
    })
    @GetMapping(value = "/code2Token")
    public ApiResult<OAuthToken> code2Token(@NotBlank(message = "授权码为空") @RequestParam(value = "code") String code,
                                            HttpServletRequest request, HttpServletResponse response) {
        return loginSupportProvider.code2Token(request, response, code);
    }

    @ApiOperation(value = "token换取token")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", required = true),
    })
    @GetMapping(value = "/token2Token")
    public ApiResult<OAuthToken> token2Token(@RequestParam(value = "token", required = false) String token,
                                             HttpServletRequest request, HttpServletResponse response) {
        return loginSupportProvider.token2Token(request, response, token);
    }
}
