package com.elitescloud.cloudt.authorization.api.provider.common;

import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;

/**
 * 登录相关请求参数名称.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public interface LoginParameterNames {

    /**
     * 登录终端
     */
    String TERMINAL = "terminal";

    /**
     * 登录类型
     */
    String LOGIN_TYPE = "login_type";

    /**
     * 平台编码
     */
    String PLATFORM = "platform_code";

    /**
     * 用户名
     */
    String USERNAME = OAuth2ParameterNames.USERNAME;

    /**
     * 密码
     */
    String PASSWORD = OAuth2ParameterNames.PASSWORD;

    /**
     * 账号
     */
    String ACCOUNT = "account";

    /**
     * 手机号
     */
    String MOBILE = "mobile";

    /**
     * 手机短信验证码
     */
    String MOBILE_SMS_CODE = "sms_code";

    /**
     * 自动注册
     */
    String AUTO_REGISTER = "auto_register";

    /**
     * 邮箱
     */
    String EMAIL = "email";

    /**
     * 手机短信验证码
     */
    String EMAIL_CODE = "code";

    /**
     * 微信-appid
     */
    String WECHAT_APPID = "wx_appid";

    /**
     * 微信-code
     */
    String WECHAT_CODE = "wx_code";

    /**
     * 微信用户-openid
     */
    String WECHAT_OPENID = "wx_openid";

    /**
     * 微信用户-unionid
     */
    String WECHAT_UNIONID = "wx_unionid";

    /**
     * 是否需要验证码
     */
    String CAPTCHA_NEED = "captcha_needed";

    /**
     * 验证码-内容
     */
    String CAPTCHA_TEXT = "captcha";

    /**
     * 验证码-key
     */
    String CAPTCHA_UID = "capuid";

    /**
     * 重定向路径
     */
    String REDIRECT_URL = "redirectUrl";
}
