package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.CaptchaProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.support.SystemUserDetailService;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatManager;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatTemplate;
import com.elitescloud.cloudt.authorization.api.provider.web.controller.LoginSupportController;
import com.elitescloud.cloudt.common.condition.ConditionalOnRpc;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.config.CloudtCoreAutoConfiguration;
import com.elitescloud.cloudt.core.verifycode.VerifyCodeConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * 可选登录扩展支持配置.
 * <p>
 * 根据登录认证方式选择
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/6
 */
@Import({LoginSupportConfig.ConfigOnRpc.class, VerifyCodeConfig.class})
@ConditionalOnClass({CloudtCoreAutoConfiguration.class})
public class LoginSupportConfig {

    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public LoginSupportConfig(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    /**
     * 登录基础支持服务
     *
     * @return
     */
    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(configProperties);
    }

    /**
     * 登录相关基础支持服务接口
     *
     * @param loginSupportProvider
     * @return
     */
    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    /**
     * 用户管理相关服务
     *
     * @return
     */
    @ConditionalOnMissingBean
    @Bean
    public UserDetailManager userDetailManagerSystem() {
        return new SystemUserDetailService(authorizationProperties);
    }

    /**
     * 验证码相关服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    /**
     * 微信相关服务
     *
     * @param wechatProperties
     * @return
     */
    @Bean
    public WechatProvider wechatProvider(WechatProperties wechatProperties) {
        return new WechatProvider(wechatProperties);
    }

    /**
     * 微信相关服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    public WechatTemplate wechatTemplate(RedisHelper redisHelper, WechatManager wechatManager) {
        return new WechatTemplate(wechatManager::getAppSecret, redisHelper);
    }

    @Bean
    @ConditionalOnMissingBean
    public WechatManager wechatManagerDefault() {
        return appId -> {
            throw new BusinessException("暂无实现");
        };
    }

    /**
     * 存在Rpc时激活相关服务
     */
    @ConditionalOnRpc
    static class ConfigOnRpc {

        /**
         * 系统域，用户服务
         *
         * @return
         */
        @Bean
        public RmiSysUserRpcService rmiSysUserRpcService() {
            return new RmiSysUserRpcService();
        }
    }
}
