package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitescloud.cloudt.authorization.api.provider.sso.SsoLoginSupportProvider;
import com.elitescloud.cloudt.authorization.api.provider.sso.impl.CloudtSsoLoginSupportProviderImpl;
import com.elitescloud.cloudt.authorization.api.provider.sso.impl.CloudtSsoProviderImpl;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket.RedisTicketGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket.TicketGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.sso.SsoTicketAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.sso.SsoLoginSupportController;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.TicketResolver;
import com.elitescloud.cloudt.authorization.sdk.sso.impl.CookieTicketResolver;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * 单点登录相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
@ConditionalOnProperty(prefix = AuthorizationSdkProperties.CONFIG_PREFIX + ".sso", name = "enabled", havingValue = "true")
@Log4j2
class SsoConfig extends AbstractServletSecurityConfig {

    private final AuthorizationSdkProperties sdkProperties;

    public SsoConfig(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
        log.info("启用单点登录功能");
    }

    @Bean
    @ConditionalOnMissingBean
    private CloudtSsoProviderImpl cloudtSsoProvider(TokenGenerator tokenGenerator
            , AuthenticationCache authenticationCache
            , UserDetailManager userDetailManager
            , RedisHelper redisHelper) {
        CloudtSsoProviderImpl provider = new CloudtSsoProviderImpl(tokenGenerator, authenticationCache, userDetailManager, redisHelper);
        provider.setSdkProperties(sdkProperties);
        provider.setAuthenticationCallable(DelegateAuthenticationCallable.getInstance());
        return provider;
    }

    @Bean
    public SsoLoginSupportController ssoLoginSupportController(SsoLoginSupportProvider ssoLoginSupportProvider) {
        return new SsoLoginSupportController(ssoLoginSupportProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoLoginSupportProvider ssoLoginSupportProvider(TicketGenerator ticketGenerator,
                                                           RmiSysUserRpcService rmiSysUserRpcService) {
        return new CloudtSsoLoginSupportProviderImpl(sdkProperties, ticketGenerator, rmiSysUserRpcService);
    }

    /**
     * 登录成功后生成ticket
     *
     * @param ticketGenerator
     * @param ticketResolver
     * @return
     */
    @Bean
    public AuthenticationCallable authenticationCallableSsoTicket(TicketGenerator ticketGenerator,
                                                                  TicketResolver ticketResolver) {
        return new SsoTicketAuthenticationCallable(sdkProperties, ticketGenerator, ticketResolver);
    }

    /**
     * ticket处理器
     *
     * @return
     */
    @Bean
    @ConditionalOnMissingBean
    public TicketResolver ticketResolverCookie() {
        return new CookieTicketResolver(sdkProperties);
    }

    /**
     * redis ticket生成器
     *
     * @param redisHelper
     * @return
     */
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(RedisHelper.class)
    public TicketGenerator ticketGenerator(RedisHelper redisHelper) {
        return new RedisTicketGenerator(redisHelper);
    }
}
