package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.TenantProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitescloud.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.TenantAuthenticationCheckServiceImpl;
import com.elitescloud.cloudt.core.common.BaseSwaggerConfig;
import com.elitescloud.cloudt.core.config.CloudtCoreAutoConfiguration;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.tenant.TenantClient;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * 系统配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/30
 */
@EnableConfigurationProperties({ConfigProperties.class, WechatProperties.class, TenantProperties.class})
@EnableScheduling
@EnableCaching
@Import({SystemConfig.TenantConfig.class, SystemConfig.SwaggerConfig.class})
@ConditionalOnClass({CloudtCoreAutoConfiguration.class})
@Log4j2
class SystemConfig {

    /**
     * 当存在租户时的配置
     */
    @ConditionalOnClass({TenantClient.class})
    static class TenantConfig {

        /**
         * 用户认证时租户相关检查
         *
         * @param tenantProperties
         * @param tenantClientProvider
         * @return
         */
        @Bean
        public AuthenticationCheckService tenantAuthenticationCheckService(TenantProperties tenantProperties,
                                                                           TenantClientProvider tenantClientProvider) {
            return new TenantAuthenticationCheckServiceImpl(tenantProperties, tenantClientProvider);
        }
    }

    @ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
    static class SwaggerConfig extends BaseSwaggerConfig {

        public SwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
            super(openApiExtensionResolver, serverProperties);
        }

        @Bean
        public Docket createRestApi() {
            return createDocket("AuthorizationServiceAPI", "com.elitescloud.cloudt.authorization");
        }
    }
}
