package com.elitescloud.cloudt.authorization.api.provider.config.servlet;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.JwtAuthenticationSuccessHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.DefaultAuthenticationFailureHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.LoginSupportConfig;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.LoginFilterSecurityConfigurer;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

/**
 * 单体认证方式.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
@Log4j2
@ConditionalOnProperty(prefix = AuthorizationProperties.CONFIG_PREFIX, name = "type", havingValue = "single")
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@Import({LoginSupportConfig.class})
public class ServletSingleConfig extends AbstractServletSecurityConfig {
    private ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers;
    private TokenGenerator tokenGenerator;

    @Bean(SECURITY_CHAIN_DEFAULT)
    @ConditionalOnMissingBean(name = SECURITY_CHAIN_DEFAULT)
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http) throws Exception {
        var successHandler = new JwtAuthenticationSuccessHandler(authorizationProperties, DelegateAuthenticationCallable.getInstance(),
                tokenGenerator);

        super.defaultSecurityConfig(http)
                .apply(new LoginFilterSecurityConfigurer<>(loginFilterCustomizers))
                .successHandler(successHandler)
                .failureHandler(new DefaultAuthenticationFailureHandler(DelegateAuthenticationCallable.getInstance()))
        ;

        return http.build();
    }

    @Autowired
    public void setLoginFilterCustomizers(ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers) {
        this.loginFilterCustomizers = loginFilterCustomizers;
    }

    @Autowired
    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}
