package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.configurer;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.OAuth2AuthorizationCodeUserVerifier;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.configurer.filter.OAuth2AuthorizationCodeUserVerifierFilter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 授权码模式认证用户配置.
 *
 * @author Kaiser（wang shao）
 * @date 2/28/2023
 */
public class OAuth2AuthorizationCodeUserSecurityConfigurer<H extends HttpSecurityBuilder<H>>
        extends AbstractHttpConfigurer<OAuth2AuthorizationCodeUserSecurityConfigurer<H>, H> {
    private final AuthorizationServerSettings authorizationServerSettings;

    private List<OAuth2AuthorizationCodeUserVerifier> userVerifiers;

    public OAuth2AuthorizationCodeUserSecurityConfigurer(AuthorizationServerSettings authorizationServerSettings) {
        this.authorizationServerSettings = authorizationServerSettings;
    }

    @Override
    public void init(H http) throws Exception {
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        this.addUserVerifierFilter(http);

        super.configure(http);
    }

    private void addUserVerifierFilter(H http) {
        if (CollUtil.isEmpty(userVerifiers)) {
            return;
        }
        OAuth2AuthorizationCodeUserVerifierFilter filter = new OAuth2AuthorizationCodeUserVerifierFilter(authorizationServerSettings.getAuthorizationEndpoint(), userVerifiers);
        http.addFilterBefore(filter, OAuth2AuthorizationEndpointFilter.class);
    }

    public OAuth2AuthorizationCodeUserSecurityConfigurer<H> userVerifiers(ObjectProvider<OAuth2AuthorizationCodeUserVerifier> userVerifierObjectProvider) {
        this.userVerifiers = userVerifierObjectProvider.stream().collect(Collectors.toList());
        return this;
    }
}
