package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler;

import com.elitescloud.cloudt.authorization.api.client.config.security.handler.AbstractHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * OAuth2认证失败处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/31
 */
@Log4j2
public class OAuth2AuthenticationFailHandler extends AbstractHandler implements AuthenticationFailureHandler {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String errorNo = FORMATTER.format(LocalDateTime.now());
        log.error("OAuth2认证异常【错误号：" + errorNo + "】：", exception);

        String msg = exception.getMessage();
        var result = ApiResult.fail(ApiCode.UNAUTHORIZED, errorNo, msg, null, "认证失败");
        super.writeResponse(response, result, HttpStatus.BAD_REQUEST);
    }
}
