package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.common.AuthorizationConstant;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.DefaultAuthenticationFailureHandler;
import com.elitescloud.cloudt.authorization.sdk.resolver.UniqueRequestResolver;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.endpoint.OAuth2ParameterNames;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/14/2023
 */
public class OAuth2ServerAuthenticationFailureHandler extends DefaultAuthenticationFailureHandler {
    private RequestCache requestCache = new HttpSessionRequestCache();

    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2ServerAuthenticationFailureHandler(AuthenticationCallable authenticationCallable, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache) {
        super(authenticationCallable);
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        // 设置客户端
        String clientId = this.obtainClientId(request, response);
        request.setAttribute(AuthorizationConstant.REQUEST_ATTRIBUTE_CLIENT_ID, clientId);

        super.onAuthenticationFailure(request, response, exception);
    }

    private String obtainClientId(HttpServletRequest request, HttpServletResponse response) {
        // 先获取认证前的请求
        SavedRequest savedRequest = requestCache.getRequest(request, response);
        if (savedRequest != null) {
            String[] clientIds = savedRequest.getParameterValues(OAuth2ParameterNames.CLIENT_ID);
            if (clientIds != null && clientIds.length > 0) {
                return clientIds[0];
            }
        }

        // 获取登录前的认证请求
        var reqId = uniqueRequestResolver.analyze(request);
        if (!StringUtils.hasText(reqId)) {
            return null;
        }

        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = authorizationCodeRequestCache.getAuthenticationToken(reqId);
        if (codeRequest == null) {
            return null;
        }
        return codeRequest.getClientId();
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }
}
