package com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket;

import com.elitescloud.cloudt.authorization.sdk.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

/**
 * ticket生成器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
public interface TicketGenerator {

    /**
     * 生成ticket
     *
     * @param user 用户信息
     * @return ticiket
     */
    String generate(SysUserDTO user);

    /**
     * 校验ticket
     * <p>
     * 当返回用户为空，则说明无效
     *
     * @param ticket ticket
     * @return 用户信息
     */
    UserInfoDTO validate(String ticket);

    /**
     * 移除ticket
     *
     * @param ticket ticket
     */
    void remove(String ticket);

    static UserInfoDTO userToUserInfoDto(SysUserDTO user) {
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setUserId(user.getId().toString());
        userInfoDTO.setUsername(user.getUsername());
        userInfoDTO.setMobile(user.getMobile());
        userInfoDTO.setEmail(user.getEmail());

        return userInfoDTO;
    }
}
