package com.elitescloud.cloudt.authorization.api.provider.security.grant.email_code;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.core.verifycode.VerifyCodeManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 邮箱和验证码的身份证认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class EmailCodeAuthenticationProvider extends AbstractCustomAuthenticationProvider<EmailCodeAuthenticationToken> {

    private VerifyCodeManager verifyCodeManager;

    @NonNull
    @Override
    protected GeneralUserDetails retrieveUser(EmailCodeAuthenticationToken authentication) throws AuthenticationException {
        String email = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(email)) {
            throw new AuthorizationException("邮箱为空");
        }

        String code = (String) authentication.getCredentials();
        if (!StringUtils.hasText(code)) {
            throw new AuthorizationException("验证码为空");
        }

        if (authentication.isAutoRegister() && !configProperties.getLogin().getAutoRegister()) {
            throw new AuthorizationException("不支持自动注册账号");
        }

        // 校验短信验证码
        String failMsg = verifyCodeManager.verify(VerifyCodeManager.BUSINESS_TYPE_AUTH_LOGIN, email, code);
        if (failMsg != null) {
            throw new AuthorizationException("邮箱错误或验证码已过期");
        }

        var user = authentication.isAutoRegister() ? userDetailManager.registerOnLoadUserByEmailNotFound(email) :
                userDetailManager.loadUserByEmail(email);
        if (user == null) {
            throw new AuthorizationException("邮箱错误或验证码已过期");
        }
        return user;
    }

    @Autowired
    public void setVerifyCodeManager(VerifyCodeManager verifyCodeManager) {
        this.verifyCodeManager = verifyCodeManager;
    }
}
