package com.elitescloud.cloudt.authorization.api.provider.security.grant.email_code;

import com.elitescloud.cloudt.authorization.api.client.common.LoginType;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitescloud.cloudt.authorization.api.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.constant.Terminal;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 邮箱和验证码的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class EmailCodeAuthenticationToken extends AbstractCustomAuthenticationToken<EmailCodeAuthenticationToken> {
    private static final long serialVersionUID = -8359205420429608593L;

    /**
     * 账号不存在时是否自动 注册
     */
    private boolean autoRegister = false;

    public EmailCodeAuthenticationToken() {
        super(null, null);
    }

    public EmailCodeAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public EmailCodeAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.EMAIL_CODE;
    }

    @NonNull
    @Override
    public EmailCodeAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.parse(terminalParam);
        }

        EmailCodeAuthenticationToken authenticationToken = new EmailCodeAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.EMAIL));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.EMAIL_CODE));
        authenticationToken.setAuthenticated(false);

        return authenticationToken;
    }

    boolean isAutoRegister() {
        return autoRegister;
    }

    void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }
}
