package com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_sms;

import com.elitescloud.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitescloud.cloudt.authorization.api.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.authorization.api.client.common.LoginType;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.common.constant.Terminal;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 手机号和短信的身份认证令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public class MobileSmsAuthenticationToken extends AbstractCustomAuthenticationToken<MobileSmsAuthenticationToken> {
    private static final long serialVersionUID = -8359205420429608593L;

    /**
     * 账号不存在时是否自动 注册
     */
    private boolean autoRegister = false;

    public MobileSmsAuthenticationToken() {
        super(null, null);
    }

    public MobileSmsAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public MobileSmsAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }

    @NonNull
    @Override
    public LoginType loginType() {
        return LoginType.MOBILE_SMS;
    }

    @NonNull
    @Override
    public MobileSmsAuthenticationToken convert(@NonNull HttpServletRequest request) {
        MultiValueMap<String, String> parameters = HttpServletUtil.getParameters(request);
        String terminalParam = parameters.getFirst(LoginParameterNames.TERMINAL);
        Terminal terminal = null;
        if (StringUtils.hasText(terminalParam)) {
            terminal = Terminal.valueOf(terminalParam);
        }

        MobileSmsAuthenticationToken authenticationToken = new MobileSmsAuthenticationToken();
        authenticationToken.setTerminal(terminal);
        authenticationToken.setPrincipal(parameters.getFirst(LoginParameterNames.MOBILE));
        authenticationToken.setCredentials(parameters.getFirst(LoginParameterNames.MOBILE_SMS_CODE));
        authenticationToken.setAuthenticated(false);
        authenticationToken.setAutoRegister("true".equalsIgnoreCase(parameters.getFirst(LoginParameterNames.AUTO_REGISTER)));

        return authenticationToken;
    }

    boolean isAutoRegister() {
        return autoRegister;
    }

    void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }
}
