package com.elitescloud.cloudt.authorization.api.provider.security.grant.wechat_phone;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatTemplate;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

/**
 * 微信openid的身份认证.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
@Log4j2
public class WechatPhoneAuthenticationProvider extends AbstractCustomAuthenticationProvider<WechatPhoneAuthenticationToken> {

    @Autowired
    private WechatTemplate wechatTemplate;

    @Override
    protected GeneralUserDetails retrieveUser(WechatPhoneAuthenticationToken authentication) throws AuthenticationException {
        String appId = (String) authentication.getPrincipal();
        if (!StringUtils.hasText(appId)) {
            throw new AuthorizationException("应用ID为空");
        }
        String code = (String) authentication.getCredentials();
        if (!StringUtils.hasText(code)) {
            throw new AuthorizationException("授权码code为空");
        }
        if (authentication.isAutoRegister() && Boolean.FALSE.equals(configProperties.getLogin().getAutoRegister())) {
            throw new AuthorizationException("不支持自动注册账号");
        }

        // 调用微信获取手机号
        var phoneInfo = wechatTemplate.getPhoneInfo(appId, code);
        if (phoneInfo == null) {
            throw new AuthorizationException("微信授权获取手机号异常");
        }
        if (!phoneInfo.isSuccess() || CharSequenceUtil.isBlank(phoneInfo.getPhoneInfo().getPurePhoneNumber())) {
            throw new AuthorizationException(String.format("调用微信服务器获取手机号失败[%s,%s]", phoneInfo.getErrCode(), phoneInfo.getErrMsg()));
        }
        String mobile = phoneInfo.getPhoneInfo().getPurePhoneNumber();

        var user = authentication.isAutoRegister() ? userDetailManager.registerOnLoadUserByMobileNotFound(mobile) :
                userDetailManager.loadUserByMobile(mobile);
        if (user == null) {
            throw new AuthorizationException("手机号错误或验证码已过期");
        }
        return user;
    }
}
