package com.elitescloud.cloudt.authorization.api.provider.security.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.security.core.AuthenticationException;

/**
 * 默认的用户认证信息检查.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
public class DefaultAuthenticationCheckServiceImpl<T extends AbstractCustomAuthenticationToken<T>> implements AuthenticationCheckService<T> {

    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public DefaultAuthenticationCheckServiceImpl(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        // 终端校验
        validTerminal(userDetails, authentication);
    }

    private void validTerminal(GeneralUserDetails userDetails, T authentication) {
        Boolean terminalEnabled = configProperties.getLogin().getTerminalLimit();
        if (!ObjectUtil.defaultIfNull(terminalEnabled, false)) {
            // 默认不校验
            return;
        }

        Terminal terminal = authentication.getTerminal();
        if (terminal == null) {
            throw new AuthorizationException("未设置登录终端");
        }

        var terminals = userDetails.getUser().getTerminals();
        if (terminals == null || terminals.isEmpty()) {
            throw new AuthorizationException("无权限登录该终端");
        }

        if (!terminals.contains(terminal)) {
            throw new AuthorizationException("无权限登录该终端");
        }
    }
}
