package com.elitescloud.cloudt.authorization.api.provider.security.jackson.mixin.grant;

import com.elitescloud.cloudt.authorization.api.client.token.CommonAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.email_code.EmailCodeAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.password.UsernamePasswordAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.client_user.ClientUserAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_pwd.MobilePasswordAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_sms.MobileSmsAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.wechat_minapp.WechatMinAppAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.wechat_phone.WechatPhoneAuthenticationToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.module.SimpleModule;

/**
 * 自定义jacksonModule.
 * <p>
 * 支持自定义AuthenticationToken类的反序列化
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/07
 */
public class CustomAuthenticationTokenJacksonModule extends SimpleModule {
    private static final long serialVersionUID = -3294671195482929553L;

    public CustomAuthenticationTokenJacksonModule() {
        super(CustomAuthenticationTokenJacksonModule.class.getName(), new Version(1, 0, 0, null, null, null));
    }

    @Override
    public void setupModule(SetupContext context) {
        context.setMixInAnnotations(CommonAuthenticationToken.class, MixinCommonAuthenticationToken.class);
        context.setMixInAnnotations(ClientUserAuthenticationToken.class, MixinClientUserAuthenticationToken.class);
        context.setMixInAnnotations(MobilePasswordAuthenticationToken.class, MixinMobilePasswordAuthenticationToken.class);
        context.setMixInAnnotations(MobileSmsAuthenticationToken.class, MixinMobileSmsAuthenticationToken.class);
        context.setMixInAnnotations(EmailCodeAuthenticationToken.class, MixinEmailCodeAuthenticationToken.class);
        context.setMixInAnnotations(UsernamePasswordAuthenticationToken.class, MixinUsernamePasswordAuthenticationToken.class);
        context.setMixInAnnotations(WechatMinAppAuthenticationToken.class, MixinWechatOpenidAuthenticationToken.class);
        context.setMixInAnnotations(WechatPhoneAuthenticationToken.class, MixinWechatPhoneAuthenticationToken.class);
    }
}
