package com.elitescloud.cloudt.authorization.api.provider.sso;

import com.elitescloud.cloudt.authorization.sdk.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.common.base.ApiResult;

/**
 * sso登录支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/15
 */
public interface SsoLoginSupportProvider {

    /**
     * 生成ticket
     *
     * @param account
     * @param accountType
     * @return
     */
    ApiResult<String> generateTicket(String account, String accountType);

    /**
     * 根据ticket获取用户信息
     *
     * @param ticket
     * @return
     */
    ApiResult<UserInfoDTO> getUserInfo(String ticket);

}
