package com.elitescloud.cloudt.authorization.api.provider.web.controller;

import com.elitescloud.cloudt.authorization.api.provider.AuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.common.LoginParameterNames;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 登录相关接口支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/6
 */
@ResponseBody
@RequestMapping(value = "/oauth/login")
@Api(tags = {"登录相关接口"})
public class LoginController {

    private final AuthenticationService authenticationService;

    public LoginController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    /**
     * 注销
     *
     * @return 退出账号
     */
    @GetMapping(value = "/logout")
    @ApiOperation("注销登录")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParam(name = LoginParameterNames.REDIRECT_URL, value = "注销后的重定向路径")
    public ApiResult<String> logout(HttpServletRequest request, HttpServletResponse response) {
        return authenticationService.logout(request, response);
    }

    /**
     * 获取当前用户信息
     *
     * @return 当前用户信息
     */
    @GetMapping(value = "/currentUser")
    @ApiOperation("获取当前用户信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<GeneralUserDetails> currentUser() {
        return authenticationService.currentUser();
    }
}
