package com.elitescloud.cloudt.authorization.api.provider.web.controller;

import com.elitescloud.cloudt.authorization.api.provider.model.vo.resp.CaptchaRespVO;
import com.elitescloud.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.verifycode.model.SysSendVerifyCodeVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

/**
 * 登录扩展支撑.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/08
 */
@ResponseBody
@RequestMapping(value = "/oauth/login")
@Validated
@Api(tags = {"登录相关支撑接口"})
public class LoginSupportController {

    private final LoginSupportProvider loginSupportProvider;

    public LoginSupportController(LoginSupportProvider loginSupportProvider) {
        this.loginSupportProvider = loginSupportProvider;
    }

    /**
     * 获取登录验证码
     *
     * @return 验证码信息
     */
    @GetMapping(value = "/captcha")
    @ApiOperation("图形验证码")
    public ApiResult<CaptchaRespVO> getCaptcha() {
        return loginSupportProvider.generateCaptcha();
    }

    /**
     * 发送登录短信验证码
     *
     * @return 发送结果
     */
    @ApiOperation(value = "消息验证码", notes = "手机短信或邮箱")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/captcha/msg")
    public ApiResult<String> getCaptchaSms(@RequestBody @Valid SysSendVerifyCodeVO verifyCodeVO) {
        return loginSupportProvider.sendVerifyCode(verifyCodeVO);
    }
}
