/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.CloudtAuthorizationCacheAutoConfiguration;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.authorization.api.provider.AuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.config.CloudtCasClientConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.SsoConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.SystemConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.ServletOAuth2ServerConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.ServletSingleConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.JwtTokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.CredentialCheckable;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.CacheUserAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.LoginLogHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.LogoutRedirectHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.DefaultAuthenticationCheckServiceImpl;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.DefaultAuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.security.listener.HttpSessionHolder;
import com.elitescloud.cloudt.authorization.api.provider.web.controller.LoginController;
import com.elitescloud.cloudt.core.config.log.config.LogProperties;
import com.elitescloud.cloudt.core.config.log.queue.LogEvent;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.lmax.disruptor.RingBuffer;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.util.Assert;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableWebSecurity(debug=false)
@Import(value={ServletSingleConfig.class, ServletOAuth2ServerConfig.class, SystemConfig.class, SsoConfig.class, CloudtCasClientConfig.class, LoginLogConfig.class})
@AutoConfigureAfter(value={CloudtAuthorizationCacheAutoConfiguration.class})
public class AuthorizationAutoConfiguration {
    private static final Logger log = LogManager.getLogger(AuthorizationAutoConfiguration.class);
    private final AuthorizationProperties authorizationProperties;

    public AuthorizationAutoConfiguration(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
        Assert.notNull((Object)authorizationProperties.getType(), (String)"\u672a\u77e5\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f");
        log.info("\u670d\u52a1\u8ba4\u8bc1\u65b9\u5f0f\uff1a{}", (Object)authorizationProperties.getType());
    }

    @Bean
    @ConditionalOnMissingBean
    TokenGenerator tokenGenerator(RSAKey rsaKey, OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer) {
        JwtEncoder jwtEncoder = JwtUtil.buildJwtEncoder((RSAKey)rsaKey);
        JwtTokenGenerator jwtTokenGenerator = new JwtTokenGenerator(this.authorizationProperties, jwtEncoder);
        jwtTokenGenerator.setTokenCustomizer(jwtCustomizer);
        return jwtTokenGenerator;
    }

    @Bean
    OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer() {
        return context -> {
            Object principal = context.getPrincipal().getPrincipal();
            JwtClaimsSet.Builder claims = context.getClaims();
            if (principal instanceof GeneralUserDetails) {
                GeneralUserDetails userDetails = (GeneralUserDetails)principal;
                claims.claim("yst_un", (Object)userDetails.getUsername());
                claims.claim("yst_ui", (Object)userDetails.getUser().getId());
                if (userDetails.getTenant() != null) {
                    claims.claim("yst_ti", (Object)userDetails.getTenant().getId());
                }
                claims.claim("yst_pt", (Object)"us");
            } else {
                claims.claim("yst_pt", (Object)"cli");
            }
        };
    }

    @Bean
    AuthenticationCallable authenticationCallableCacheUser(AuthenticationCache authenticationCache) {
        return new CacheUserAuthenticationCallable(this.authorizationProperties, authenticationCache);
    }

    @Bean
    @ConditionalOnMissingBean
    AuthenticationService authenticationService(@Autowired(required=false) LogoutRedirectHandler logoutRedirectHandler) {
        return new DefaultAuthenticationService(DelegateAuthenticationCallable.getInstance(), logoutRedirectHandler);
    }

    @Bean
    @ConditionalOnBean(value={AuthenticationService.class})
    LoginController loginSupportController(AuthenticationService authenticationService) {
        return new LoginController(authenticationService);
    }

    @Bean
    AuthenticationCheckService defaultAuthenticationCheckService(ConfigProperties configProperties) {
        return new DefaultAuthenticationCheckServiceImpl(this.authorizationProperties, configProperties);
    }

    @Bean
    @ConditionalOnBean(value={UserDetailManager.class})
    InternalAuthenticationGranter internalAuthenticationGranter(UserDetailManager userDetailManager, TokenGenerator tokenGenerator) {
        InternalAuthenticationGranter granter = new InternalAuthenticationGranter(userDetailManager, tokenGenerator);
        granter.setDelegateAuthenticationCallable(DelegateAuthenticationCallable.getInstance());
        return granter;
    }

    @Bean
    ServletListenerRegistrationBean<HttpSessionHolder> servletListenerRegistrationBeanHttpSession() {
        ServletListenerRegistrationBean listenerRegistrationBean = new ServletListenerRegistrationBean();
        listenerRegistrationBean.setListener((EventListener)((Object)new HttpSessionHolder()));
        listenerRegistrationBean.setEnabled(true);
        return listenerRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    CredentialCheckable credentialCheckable() {
        return new CredentialCheckable(){

            @Override
            public <T extends AbstractCustomAuthenticationToken<T>> boolean needCheck(T authenticationToken, GeneralUserDetails userDetails) {
                return true;
            }
        };
    }

    @ConditionalOnProperty(prefix="elitesland.log.login-log", name={"enabled"}, havingValue="true")
    @EnableConfigurationProperties(value={LogProperties.class})
    static class LoginLogConfig {
        private final LogProperties logProperties;
        private final RingBuffer<LogEvent> ringBuffer;

        public LoginLogConfig(LogProperties logProperties, RingBuffer<LogEvent> ringBuffer) {
            this.logProperties = logProperties;
            this.ringBuffer = ringBuffer;
            log.info("\u542f\u7528\u767b\u5f55\u65e5\u5fd7\u7eaa\u5f55");
        }

        @Bean
        public AuthenticationCallable authenticationCallbackLoginLog(final LoginLogHandler loginLogHandler) {
            return new AuthenticationCallable(){

                public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
                    loginLogHandler.loginLog(request, authentication, null);
                }

                public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, @NotNull Authentication authentication, @NotNull AuthenticationException exception) {
                    loginLogHandler.loginLog(request, null, exception);
                }
            };
        }

        @Bean
        public LoginLogHandler loginLogHandler() {
            return new LoginLogHandler(this.ringBuffer, this.logProperties);
        }
    }
}

