/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.CaptchaProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.support.SystemUserDetailService;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatManager;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatTemplate;
import com.elitescloud.cloudt.authorization.api.provider.web.controller.LoginSupportController;
import com.elitescloud.cloudt.common.condition.ConditionalOnRpc;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.config.CloudtCoreAutoConfiguration;
import com.elitescloud.cloudt.core.verifycode.VerifyCodeConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={ConfigOnRpc.class, VerifyCodeConfig.class})
@ConditionalOnClass(value={CloudtCoreAutoConfiguration.class})
public class LoginSupportConfig {
    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public LoginSupportConfig(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(this.configProperties);
    }

    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    @ConditionalOnMissingBean
    @Bean
    public UserDetailManager userDetailManagerSystem() {
        return new SystemUserDetailService(this.authorizationProperties);
    }

    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    @Bean
    public WechatProvider wechatProvider(WechatProperties wechatProperties) {
        return new WechatProvider(wechatProperties);
    }

    @Bean
    public WechatTemplate wechatTemplate(RedisHelper redisHelper, WechatManager wechatManager) {
        return new WechatTemplate(wechatManager::getAppSecret, redisHelper);
    }

    @Bean
    @ConditionalOnMissingBean
    public WechatManager wechatManagerDefault() {
        return appId -> {
            throw new BusinessException("\u6682\u65e0\u5b9e\u73b0");
        };
    }

    @ConditionalOnRpc
    static class ConfigOnRpc {
        ConfigOnRpc() {
        }

        @Bean
        public RmiSysUserRpcService rmiSysUserRpcService() {
            return new RmiSysUserRpcService();
        }
    }
}

