/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config;

import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.TenantProperties;
import com.elitescloud.cloudt.authorization.api.provider.config.system.WechatProperties;
import com.elitescloud.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.TenantAuthenticationCheckServiceImpl;
import com.elitescloud.cloudt.core.common.BaseSwaggerConfig;
import com.elitescloud.cloudt.core.config.CloudtCoreAutoConfiguration;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.tenant.TenantClient;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;
import springfox.documentation.spring.web.plugins.Docket;

@EnableConfigurationProperties(value={ConfigProperties.class, WechatProperties.class, TenantProperties.class})
@EnableScheduling
@EnableCaching
@Import(value={TenantConfig.class, SwaggerConfig.class})
@ConditionalOnClass(value={CloudtCoreAutoConfiguration.class})
class SystemConfig {
    private static final Logger log = LogManager.getLogger(SystemConfig.class);

    SystemConfig() {
    }

    @ConditionalOnProperty(prefix="knife4j", name={"enable"}, havingValue="true")
    static class SwaggerConfig
    extends BaseSwaggerConfig {
        public SwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
            super(openApiExtensionResolver, serverProperties);
        }

        @Bean
        public Docket createRestApi() {
            return this.createDocket("AuthorizationServiceAPI", new String[]{"com.elitescloud.cloudt.authorization"});
        }
    }

    @ConditionalOnClass(value={TenantClient.class})
    static class TenantConfig {
        TenantConfig() {
        }

        @Bean
        public AuthenticationCheckService tenantAuthenticationCheckService(TenantProperties tenantProperties, TenantClientProvider tenantClientProvider) {
            return new TenantAuthenticationCheckServiceImpl(tenantProperties, tenantClientProvider);
        }
    }
}

