/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet;

import com.elitescloud.cloudt.authorization.api.client.config.security.AbstractServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAccessDeniedHandler;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.authorization.api.provider.config.LoginSupportConfig;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.OAuth2AuthorizationCodeUserVerifier;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.configurer.OAuth2AuthorizationCodeStateFilterSecurityConfigurer;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.configurer.OAuth2AuthorizationCodeUserSecurityConfigurer;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2AccessTokenResponseHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2AuthenticationFailHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2AuthorizationErrorResponseHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2AuthorizationResponseHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2ServerAuthenticationFailureHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2ServerAuthenticationSuccessHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2ServerJsonAuthenticationEntryPointHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2ServerLoginUrlAuthenticationEntryPointHandler;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.OAuth2ServerLogoutRedirectHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.LoginFilterSecurityConfigurer;
import com.elitescloud.cloudt.authorization.api.provider.security.configurer.support.LoginFilterCustomizer;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.api.provider.security.impl.RedisOAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.authorization.sdk.resolver.UniqueRequestResolver;
import com.elitescloud.cloudt.authorization.sdk.resolver.impl.DefaultUniquestResolver;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.Principal;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(prefix="elitesland.authorization", name={"type"}, havingValue="oauth2_server")
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Import(value={LoginSupportConfig.class})
public class ServletOAuth2ServerConfig
extends AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(ServletOAuth2ServerConfig.class);
    private ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers;
    private ObjectProvider<OAuth2AuthorizationCodeUserVerifier> auth2AuthorizeUserVerifiers;
    private final UniqueRequestResolver uniqueRequestResolver = ServletOAuth2ServerConfig.getOAuth2UniqueRequestResolver();

    @Bean(value={"authorizationServerSecurityFilterChain"})
    @Order(value=-2147483648)
    @ConditionalOnMissingBean(name={"authorizationServerSecurityFilterChain"})
    public SecurityFilterChain authorizationServerSecurityFilterChain(HttpSecurity http, OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache, AuthorizationServerSettings serverSettings, RegisteredClientRepository registeredClientRepository) throws Exception {
        RequestCache requestCache = AbstractServletSecurityConfig.getRequestCache();
        OAuth2AuthenticationFailHandler authenticationFailureHandler = new OAuth2AuthenticationFailHandler();
        OAuth2ServerJsonAuthenticationEntryPointHandler entryPointHandler = new OAuth2ServerJsonAuthenticationEntryPointHandler(authorizationCodeRequestCache, serverSettings.getAuthorizationEndpoint());
        entryPointHandler.setUniqueRequestResolver(this.uniqueRequestResolver);
        DefaultAccessDeniedHandler accessDeniedHandler = new DefaultAccessDeniedHandler();
        OAuth2AuthorizationErrorResponseHandler authorizationErrorHandler = new OAuth2AuthorizationErrorResponseHandler();
        OAuth2AuthorizationServerConfigurer authorizationServerConfigurer = new OAuth2AuthorizationServerConfigurer();
        RequestMatcher endpointsMatcher = authorizationServerConfigurer.getEndpointsMatcher();
        authorizationServerConfigurer.authorizationEndpoint(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authorizationErrorHandler).authorizationResponseHandler((AuthenticationSuccessHandler)new OAuth2AuthorizationResponseHandler())).clientAuthentication(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authenticationFailureHandler)).tokenEndpoint(configurer -> configurer.errorResponseHandler((AuthenticationFailureHandler)authenticationFailureHandler).accessTokenResponseHandler((AuthenticationSuccessHandler)new OAuth2AccessTokenResponseHandler())).oidc(configurer -> configurer.userInfoEndpoint(userInfoEndpoint -> userInfoEndpoint.userInfoMapper(this.oidcUserInfoMapper())));
        ((HttpSecurity)((OAuth2AuthorizationCodeUserSecurityConfigurer)((HttpSecurity)((OAuth2AuthorizationCodeStateFilterSecurityConfigurer)((HttpSecurity)((OAuth2AuthorizationServerConfigurer)http.requestMatcher(endpointsMatcher).authorizeRequests(req -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)req.anyRequest()).authenticated()).csrf(csrf -> {
            if (Boolean.FALSE.equals(this.authorizationProperties.getCsrfEnabled())) {
                csrf.disable();
                return;
            }
            csrf.ignoringRequestMatchers(new RequestMatcher[]{endpointsMatcher});
        }).apply((SecurityConfigurerAdapter)authorizationServerConfigurer)).and()).apply(new OAuth2AuthorizationCodeStateFilterSecurityConfigurer(serverSettings))).uniqueRequestResolver(this.uniqueRequestResolver).and()).apply(new OAuth2AuthorizationCodeUserSecurityConfigurer(serverSettings))).userVerifiers(this.auth2AuthorizeUserVerifiers).and()).exceptionHandling(configurer -> {
            if (StringUtils.hasText((String)this.authorizationProperties.getLoginPage())) {
                OAuth2ServerLoginUrlAuthenticationEntryPointHandler loginUrlEntryPoint = new OAuth2ServerLoginUrlAuthenticationEntryPointHandler(this.authorizationProperties.getLoginPage(), registeredClientRepository, authorizationCodeRequestCache);
                loginUrlEntryPoint.setUniqueRequestResolver(this.uniqueRequestResolver);
                loginUrlEntryPoint.setRequestCache(requestCache);
                configurer.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)entryPointHandler, (RequestMatcher)new RequestHeaderRequestMatcher("X-Auth-Redirect", "false")).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)loginUrlEntryPoint, (RequestMatcher)new AntPathRequestMatcher("/**"));
            } else {
                configurer.authenticationEntryPoint((AuthenticationEntryPoint)entryPointHandler);
            }
            configurer.accessDeniedHandler((AccessDeniedHandler)accessDeniedHandler);
        });
        http.oauth2ResourceServer(super.oauth2ResourceServer());
        this.corsConfiguration(http);
        return (SecurityFilterChain)http.build();
    }

    @Bean(value={"defaultSecurityFilterChain"})
    @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http, TokenGenerator tokenGenerator, OAuth2AuthorizationCodeRequestCache auth2AuthorizationCodeRequestCache, RegisteredClientRepository clientRepository, OAuth2AuthorizationService authorizationService, AuthorizationServerSettings serverSettings) throws Exception {
        RequestCache requestCache = AbstractServletSecurityConfig.getRequestCache();
        OAuth2ServerAuthenticationSuccessHandler auth2ServerAuthenticationSuccessHandler = new OAuth2ServerAuthenticationSuccessHandler(serverSettings.getAuthorizationEndpoint(), this.authorizationProperties, auth2AuthorizationCodeRequestCache, clientRepository, authorizationService);
        auth2ServerAuthenticationSuccessHandler.setTokenGenerator(tokenGenerator);
        DelegateAuthenticationCallable authenticationCallable = DelegateAuthenticationCallable.getInstance();
        auth2ServerAuthenticationSuccessHandler.setAuthenticationCallable((AuthenticationCallable)authenticationCallable);
        auth2ServerAuthenticationSuccessHandler.setUniqueRequestResolver(this.uniqueRequestResolver);
        auth2ServerAuthenticationSuccessHandler.setRequestCache(requestCache);
        OAuth2ServerAuthenticationFailureHandler failureHandler = new OAuth2ServerAuthenticationFailureHandler((AuthenticationCallable)authenticationCallable, auth2AuthorizationCodeRequestCache);
        failureHandler.setUniqueRequestResolver(this.uniqueRequestResolver);
        failureHandler.setRequestCache(requestCache);
        ((LoginFilterSecurityConfigurer)((Object)((LoginFilterSecurityConfigurer)super.defaultSecurityConfig(http).apply(new LoginFilterSecurityConfigurer<HttpSecurity>(this.loginFilterCustomizers))).successHandler(auth2ServerAuthenticationSuccessHandler))).failureHandler(failureHandler);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizationCodeRequestCache oAuth2AuthorizationCodeRequestCache(RedisHelper redisHelper) {
        return new RedisOAuth2AuthorizationCodeRequestCache(redisHelper);
    }

    @Bean
    public JWKSource<SecurityContext> jwkSource(RSAKey rsaKey) {
        return JwtUtil.generateJwkSource((RSAKey)rsaKey);
    }

    @Bean
    public AuthorizationServerSettings authorizationServerSettings() {
        AuthorizationServerSettings.Builder builder = AuthorizationServerSettings.builder();
        if (StringUtils.hasText((String)this.authorizationProperties.getIssuerUrl())) {
            builder.issuer(this.authorizationProperties.getIssuerUrl());
        }
        return builder.build();
    }

    @Autowired
    public void setLoginFilterCustomizers(ObjectProvider<LoginFilterCustomizer<HttpSecurity>> loginFilterCustomizers) {
        this.loginFilterCustomizers = loginFilterCustomizers;
    }

    @Autowired
    public void setAuth2AuthorizeUserVerifiers(ObjectProvider<OAuth2AuthorizationCodeUserVerifier> auth2AuthorizeUserVerifiers) {
        this.auth2AuthorizeUserVerifiers = auth2AuthorizeUserVerifiers;
    }

    @Bean
    public AuthenticationCallable oauth2AuthenticationCallable() {
        return new AuthenticationCallable(){

            public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
                String reqId = ServletOAuth2ServerConfig.this.uniqueRequestResolver.analyze(request);
                if (StringUtils.hasText((String)reqId)) {
                    ServletOAuth2ServerConfig.this.uniqueRequestResolver.clear(response, reqId);
                }
            }
        };
    }

    @Bean
    public OAuth2ServerLogoutRedirectHandler oAuth2ServerLogoutRedirectHandler(OAuth2AuthorizationCodeRequestCache auth2AuthorizationCodeRequestCache, RegisteredClientRepository clientRepository) {
        OAuth2ServerLogoutRedirectHandler handler = new OAuth2ServerLogoutRedirectHandler(clientRepository, this.authorizationProperties, auth2AuthorizationCodeRequestCache);
        handler.setRequestCache(AbstractServletSecurityConfig.getRequestCache());
        handler.setUniqueRequestResolver(this.uniqueRequestResolver);
        return handler;
    }

    public static UniqueRequestResolver getOAuth2UniqueRequestResolver() {
        DefaultUniquestResolver resolver = new DefaultUniquestResolver("X-OAuth2-Urq");
        resolver.setCookieMaxAge(-1);
        return resolver;
    }

    private Function<OidcUserInfoAuthenticationContext, OidcUserInfo> oidcUserInfoMapper() {
        return authenticationContext -> {
            OAuth2Authorization authorization = authenticationContext.getAuthorization();
            Object principal = authorization.getAttribute(Principal.class.getName());
            if (principal instanceof AbstractCustomAuthenticationToken) {
                AbstractCustomAuthenticationToken authenticationToken = (AbstractCustomAuthenticationToken)principal;
                GeneralUserDetails userDetails = (GeneralUserDetails)authenticationToken.getPrincipal();
                return OidcUserInfo.builder().subject(userDetails.getUsername()).name(userDetails.getUser().getPrettyName()).phoneNumber(userDetails.getUser().getMobile()).email(userDetails.getUser().getEmail()).claim("cloudt_ui", (Object)userDetails.getUserId()).claim("cloudt_tl", (Object)authenticationToken.getTerminal()).build();
            }
            return OidcUserInfo.builder().subject(authorization.getPrincipalName()).build();
        };
    }
}

