/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.configurer.filter;

import com.elitescloud.cloudt.authorization.api.client.common.SecurityConstants;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.OAuth2AuthorizationCodeUserVerifier;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.configurer.filter.AbstractOAuth2Filter;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class OAuth2AuthorizationCodeUserVerifierFilter
extends AbstractOAuth2Filter {
    private static final Logger log = LogManager.getLogger(OAuth2AuthorizationCodeUserVerifierFilter.class);
    private final RequestMatcher oauth2AuthorizationEndpointRequestMatcher;
    private final List<OAuth2AuthorizationCodeUserVerifier> auth2AuthorizeUserVerifiers;

    public OAuth2AuthorizationCodeUserVerifierFilter(String oauth2AuthorizationEndpointRequestMatcher, List<OAuth2AuthorizationCodeUserVerifier> auth2AuthorizeUserVerifiers) {
        this.oauth2AuthorizationEndpointRequestMatcher = super.buildOAuth2AuthorizationEndpointRequestMatcher(oauth2AuthorizationEndpointRequestMatcher);
        this.auth2AuthorizeUserVerifiers = auth2AuthorizeUserVerifiers;
    }

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        if (!this.oauth2AuthorizationEndpointRequestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String clientId = request.getParameter("client_id");
        if (!StringUtils.hasText((String)clientId)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!super.isPrincipalAuthenticated(authentication)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        for (OAuth2AuthorizationCodeUserVerifier auth2AuthorizeUserVerifier : this.auth2AuthorizeUserVerifiers) {
            if (auth2AuthorizeUserVerifier.verify(clientId, authentication)) {
                log.info("\u5df2\u8ba4\u8bc1\u7528\u6237{}\u4e0e\u5ba2\u6237\u7aef{}\u5df2\u7ed1\u5b9a", (Object)authentication.getName(), (Object)clientId);
                continue;
            }
            log.info("\u5df2\u8ba4\u8bc1\u7528\u6237{}\u4e0e\u5ba2\u6237\u7aef{}\u672a\u7ed1\u5b9a", (Object)authentication.getName(), (Object)clientId);
            SecurityContextHolder.getContext().setAuthentication((Authentication)SecurityConstants.AUTHENTICATION_ANONYMOUS);
            break;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

