/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler;

import com.elitescloud.cloudt.authorization.api.client.config.security.handler.AbstractHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class OAuth2AuthenticationFailHandler
extends AbstractHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LogManager.getLogger(OAuth2AuthenticationFailHandler.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String errorNo = FORMATTER.format(LocalDateTime.now());
        log.error("OAuth2\u8ba4\u8bc1\u5f02\u5e38\u3010\u9519\u8bef\u53f7\uff1a" + errorNo + "\u3011\uff1a", (Throwable)exception);
        String msg = exception.getMessage();
        ApiResult result = ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED, (String)errorNo, (String)msg, null, (String)"\u8ba4\u8bc1\u5931\u8d25");
        super.writeResponse(response, (Object)result, HttpStatus.BAD_REQUEST);
    }
}

