/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler;

import com.elitescloud.cloudt.authorization.api.client.util.HttpServletUtil;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.AbstractOAuth2ServerHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthorizationErrorResponseHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LogManager.getLogger(OAuth2AuthorizationErrorResponseHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        log.info("OAuth2\u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)exception);
        if (super.supportRedirect(request)) {
            this.sendErrorResponse(request, response, exception);
            return;
        }
        this.sendErrorResponseByJson(request, response, exception);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null || !StringUtils.hasText((String)authorizationCodeRequestAuthentication.getRedirectUri())) {
            HttpServletUtil.writeJsonIgnoreException((HttpServletResponse)response, (Object)error);
            return;
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationCodeRequestAuthentication.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
        if (StringUtils.hasText((String)error.getDescription())) {
            uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
        }
        if (StringUtils.hasText((String)error.getUri())) {
            uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            uriBuilder.queryParam("state", new Object[]{authorizationCodeRequestAuthentication.getState()});
        }
        this.redirectStrategy.sendRedirect(request, response, uriBuilder.toUriString());
    }

    private void sendErrorResponseByJson(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2AuthorizationCodeRequestAuthenticationException authorizationCodeRequestAuthenticationException = (OAuth2AuthorizationCodeRequestAuthenticationException)exception;
        OAuth2Error error = authorizationCodeRequestAuthenticationException.getError();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = authorizationCodeRequestAuthenticationException.getAuthorizationCodeRequestAuthentication();
        if (authorizationCodeRequestAuthentication == null) {
            this.writeResponse(response, ApiResult.fail((String)"\u8bf7\u6c42\u65b9\u5f0f\u6216\u53c2\u6570\u6709\u8bef"), HttpStatus.BAD_REQUEST);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", error.getErrorCode());
        if (StringUtils.hasText((String)error.getDescription())) {
            result.put("error_description", error.getDescription());
        }
        if (StringUtils.hasText((String)error.getUri())) {
            result.put("error_uri", error.getUri());
        }
        if (StringUtils.hasText((String)authorizationCodeRequestAuthentication.getState())) {
            result.put("state", authorizationCodeRequestAuthentication.getState());
        }
        this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED, result), HttpStatus.UNAUTHORIZED);
    }
}

