/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler;

import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.AbstractOAuth2ServerHandler;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.StringUtils;

public class OAuth2AuthorizationResponseHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationSuccessHandler {
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        OAuth2AuthorizationCodeRequestAuthenticationToken authenticationToken = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication;
        if (this.supportRedirect(request)) {
            this.sendAuthorizationResponse(request, response, (Authentication)authenticationToken);
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("code", authenticationToken.getAuthorizationCode().getTokenValue());
        if (StringUtils.hasText((String)authenticationToken.getState())) {
            result.put("state", authenticationToken.getState());
        }
        this.writeResponse(response, ApiResult.ok(result));
    }
}

