/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler;

import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.OAuth2AuthorizationCodeRequestCache;
import com.elitescloud.cloudt.authorization.api.provider.config.servlet.oauth2.handler.AbstractOAuth2ServerHandler;
import com.elitescloud.cloudt.authorization.sdk.resolver.UniqueRequestResolver;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2AuthorizationCodeRequestAuthenticationConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class OAuth2ServerJsonAuthenticationEntryPointHandler
extends AbstractOAuth2ServerHandler
implements AuthenticationEntryPoint {
    private static final Logger log = LogManager.getLogger(OAuth2ServerJsonAuthenticationEntryPointHandler.class);
    private final OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache;
    private final RequestMatcher oauth2AuthorizationEndpointRequestMatcher;
    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2ServerJsonAuthenticationEntryPointHandler(OAuth2AuthorizationCodeRequestCache authorizationCodeRequestCache, String oauth2AuthorizationEndpoint) {
        this.authorizationCodeRequestCache = authorizationCodeRequestCache;
        this.oauth2AuthorizationEndpointRequestMatcher = this.buildOAuth2AuthorizationEndpointRequestMatcher(oauth2AuthorizationEndpoint);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        log.info("{}\u672a\u8ba4\u8bc1\uff0c\u9700\u524d\u7aef\u8f6c\u5411\u767b\u5f55\u9875", (Object)request.getRequestURI());
        this.cacheAuthorizeRequest(request, response);
        this.writeResponse(response, ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED, (String)"\u672a\u8ba4\u8bc1\u6216\u8eab\u4efd\u8ba4\u8bc1\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"), HttpStatus.UNAUTHORIZED);
    }

    private void cacheAuthorizeRequest(HttpServletRequest request, HttpServletResponse response) {
        if (!this.oauth2AuthorizationEndpointRequestMatcher.matches(request)) {
            return;
        }
        OAuth2AuthorizationCodeRequestAuthenticationToken codeRequest = (OAuth2AuthorizationCodeRequestAuthenticationToken)new OAuth2AuthorizationCodeRequestAuthenticationConverter().convert(request);
        if (this.uniqueRequestResolver != null) {
            String reqId = this.uniqueRequestResolver.signRequest(response);
            this.authorizationCodeRequestCache.setAuthenticationToken(reqId, codeRequest, null);
        }
    }

    private RequestMatcher buildOAuth2AuthorizationEndpointRequestMatcher(String oauth2AuthorizationEndpoint) {
        return new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(oauth2AuthorizationEndpoint, HttpMethod.GET.name()), new AntPathRequestMatcher(oauth2AuthorizationEndpoint, HttpMethod.POST.name())});
    }

    public void setUniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
    }
}

