/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class RmiSysUserRpcService {
    private static final Logger log = LogManager.getLogger(RmiSysUserRpcService.class);
    private static final String SERVER_ERROR_MSG = "\u7cfb\u7edf\u57df\u5f02\u5e38";
    @DubboReference
    @Autowired(required=false)
    private SysUserRpcService sysUserRpcService;

    public ApiResult<SysUserDTO> getUserByUsername(String username) {
        try {
            log.info("token\uff1a{}", (Object)SecurityContextUtil.currentToken());
            return this.sysUserRpcService.getUserByUsername(username);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7528\u6237\u540d\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    public ApiResult<SysUserDTO> getUserByWechatOpenid(String openid) {
        try {
            return this.sysUserRpcService.getUserByWechatOpenid(openid);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5fae\u4fe1\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    public ApiResult<SysUserDTO> getUserByMobile(String mobile) {
        try {
            return this.sysUserRpcService.getUserByMobile(mobile);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    public ApiResult<SysUserDTO> getUserByEmail(String email) {
        try {
            return this.sysUserRpcService.getUserByEmail(email);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u90ae\u7bb1\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    public ApiResult<SysUserDTO> getUserById(String userId) {
        try {
            return this.sysUserRpcService.getUserById(userId);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    public ApiResult<SysUserDTO> getUserByAccount(String account) {
        try {
            return this.sysUserRpcService.getUserByAccount(account);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }

    public ApiResult<String> updateUserWechatOpenid(String userName, String openid) {
        try {
            return this.sysUserRpcService.updateUserWechatOpenid(userName, openid);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7528\u6237\u5fae\u4fe1\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new AuthorizationException(SERVER_ERROR_MSG, (Throwable)e);
        }
    }
}

