/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.user.support;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SystemUserDetailService
extends AbstractUserDetailManager {
    private static final Logger log = LogManager.getLogger(SystemUserDetailService.class);
    private RmiSysUserRpcService rmiSysUserRpcService;

    public SystemUserDetailService(AuthorizationProperties authorizationProperties) {
        super(authorizationProperties);
        log.info("\u8d26\u53f7\u6765\u6e90\uff1a\u7cfb\u7edf\u4e2d\u5fc3");
    }

    @Override
    public GeneralUserDetails loadUserByUsername(String username) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByUsername(username).getData());
    }

    @Override
    public GeneralUserDetails loadUserByMobile(String mobile) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByMobile(mobile).getData());
    }

    @Override
    public GeneralUserDetails loadUserByEmail(String email) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByEmail(email).getData());
    }

    @Override
    public GeneralUserDetails loadUserById(String userId) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserById(userId).getData());
    }

    @Override
    public GeneralUserDetails loadUserByAccount(String account) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByAccount(account).getData());
    }

    @Override
    public GeneralUserDetails loadUserByWechatOpenid(String wechatOpenid) {
        return this.loadUser(() -> (SysUserDTO)this.rmiSysUserRpcService.getUserByWechatOpenid(wechatOpenid).getData());
    }

    private GeneralUserDetails loadUser(Supplier<SysUserDTO> userDTOSupplier) {
        SysUserDTO user = userDTOSupplier.get();
        if (user == null) {
            return null;
        }
        return super.wrapUserDetails(user);
    }

    @Autowired
    public void setRmiSysUserRpcService(RmiSysUserRpcService rmiSysUserRpcService) {
        this.rmiSysUserRpcService = rmiSysUserRpcService;
    }
}

