/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.provider.wechat;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.WechatTool;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.param.BaseWechatResult;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.param.WechatPhoneInfo;
import com.elitescloud.cloudt.authorization.api.provider.provider.wechat.param.WechatToken;
import com.elitescloud.cloudt.common.exception.BusinessException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WechatTemplate {
    private static final Logger log = LogManager.getLogger(WechatTemplate.class);
    private final Function<String, String> getAppSecretFunction;
    private final RedisHelper redisHelper;
    private final WechatTool wechatTool;

    public WechatTemplate(@NotNull UnaryOperator<String> getAppSecretFunction, @NotNull RedisHelper redisHelper) {
        this.getAppSecretFunction = getAppSecretFunction;
        this.redisHelper = redisHelper;
        this.wechatTool = WechatTool.getInstance();
    }

    public WechatPhoneInfo getPhoneInfo(@NotBlank String appId, @NotBlank String code) {
        Assert.hasText((String)appId, (String)"\u5fae\u4fe1\u5e94\u7528ID\u4e3a\u7a7a");
        Assert.hasText((String)code, (String)"\u5fae\u4fe1\u6388\u6743\u7801\u4e3a\u7a7a");
        return this.executeWithToken(appId, token -> this.wechatTool.getPhoneNumber((String)token, code));
    }

    private <T extends BaseWechatResult> T executeWithToken(@NotBlank String appId, @NotNull Function<String, T> supplier) {
        String accessToken = this.getAccessToken(appId);
        BaseWechatResult result = (BaseWechatResult)supplier.apply(accessToken);
        if (result.isSuccess()) {
            return (T)result;
        }
        this.clearAccessToken(appId);
        result = (BaseWechatResult)supplier.apply(accessToken);
        if (!result.isSuccess()) {
            log.error("\u8c03\u7528\u5fae\u4fe1\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)result);
        }
        return (T)result;
    }

    private String getAccessToken(String appId) {
        String key = "wechat:accesstoken:" + appId;
        String accessToken = (String)this.redisHelper.execute(redisUtils -> redisUtils.get(key));
        if (StringUtils.hasText((String)accessToken)) {
            return accessToken;
        }
        String appSecret = this.getAppSecretFunction.apply(appId);
        WechatToken tokenResult = this.wechatTool.getAccessToken(appId, appSecret);
        if (tokenResult == null || CharSequenceUtil.isBlank((CharSequence)tokenResult.getAccessToken())) {
            throw new BusinessException("\u5fae\u4fe1\u6388\u6743\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.redisHelper.execute(redisUtils -> redisUtils.set(key, (Object)tokenResult.getAccessToken(), (long)tokenResult.getExpiresIn().intValue()));
        return tokenResult.getAccessToken();
    }

    private void clearAccessToken(String appId) {
        String key = "wechat:accesstoken:" + appId;
        this.redisHelper.execute(redisUtils -> {
            redisUtils.del(new String[]{key});
            return null;
        });
    }
}

