/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket;

import cn.hutool.core.util.IdUtil;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket.TicketGenerator;
import com.elitescloud.cloudt.authorization.sdk.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class RedisTicketGenerator
implements TicketGenerator {
    private static final Logger log = LogManager.getLogger(RedisTicketGenerator.class);
    private final RedisHelper redisHelper;

    public RedisTicketGenerator(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    public String generate(SysUserDTO user) {
        String ticket = IdUtil.fastSimpleUUID();
        UserInfoDTO userInfoDTO = TicketGenerator.userToUserInfoDto(user);
        try {
            this.redisHelper.execute(redisUtils -> redisUtils.set("cloudt:sso:" + ticket, (Object)userInfoDTO));
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u7528\u6237ticket\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("\u751f\u6210ticket\u5931\u8d25", (Throwable)e);
        }
        log.info("\u7528\u6237{}\u751f\u6210ticket\uff1a{}", (Object)user.getUsername(), (Object)ticket);
        return ticket;
    }

    @Override
    public UserInfoDTO validate(String ticket) {
        if (StringUtils.hasText((String)ticket)) {
            try {
                return (UserInfoDTO)this.redisHelper.execute(redisUtils -> redisUtils.get("cloudt:sso:" + ticket));
            }
            catch (Exception e) {
                log.error("\u6839\u636eticket\u83b7\u53d6\u7f13\u5b58\u7528\u6237ticket\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u6821\u9a8cticket\u5931\u8d25", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void remove(String ticket) {
        if (StringUtils.hasText((String)ticket)) {
            try {
                this.redisHelper.execute(redisUtils -> {
                    redisUtils.del(new String[]{"cloudt:sso:" + ticket});
                    return null;
                });
            }
            catch (Exception e) {
                log.error("\u6839\u636eticket\u5220\u9664\u7f13\u5b58\u7528\u6237ticket\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BusinessException("\u5220\u9664ticket\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

