/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.generator.token;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

public class JwtTokenGenerator
implements TokenGenerator {
    private static final Logger log = LogManager.getLogger(JwtTokenGenerator.class);
    private static final String ISSUER_DEFAULT = "cloudt";
    private final AuthorizationProperties authorizationProperties;
    private final JwtEncoder jwtEncoder;
    private OAuth2TokenCustomizer<JwtEncodingContext> tokenCustomizer;

    public JwtTokenGenerator(AuthorizationProperties authorizationProperties, JwtEncoder jwtEncoder) {
        this.authorizationProperties = authorizationProperties;
        this.jwtEncoder = jwtEncoder;
    }

    @Override
    public OAuthToken generate(Authentication authentication) {
        Jwt jwt = this.generateJwt(authentication);
        return this.convertToken(jwt);
    }

    public void setTokenCustomizer(OAuth2TokenCustomizer<JwtEncodingContext> tokenCustomizer) {
        this.tokenCustomizer = tokenCustomizer;
    }

    private Jwt generateJwt(Authentication authentication) {
        Duration ttl;
        Instant issuedAt = Instant.now();
        JwtClaimsSet.Builder claimBuilder = JwtClaimsSet.builder().issuer(ISSUER_DEFAULT).subject(authentication.getName()).audience(Collections.singletonList(authentication.getName())).issuedAt(issuedAt);
        if ((this.authorizationProperties.getTokenRenewal() == null || this.authorizationProperties.getTokenRenewal().toSeconds() < 1L) && (ttl = this.cachePrincipalDuration()) != null) {
            claimBuilder.expiresAt(issuedAt.plus(ttl));
        }
        JwsHeader.Builder headersBuilder = JwsHeader.with((JwsAlgorithm)SignatureAlgorithm.RS256);
        JwtEncodingContext.Builder jwtContextBuilder = (JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)JwtEncodingContext.with((JwsHeader.Builder)headersBuilder, (JwtClaimsSet.Builder)claimBuilder).principal(authentication)).tokenType(OAuth2TokenType.ACCESS_TOKEN)).authorizationGrantType(AuthorizationGrantType.JWT_BEARER);
        JwtEncodingContext jwtContext = jwtContextBuilder.build();
        if (this.tokenCustomizer != null) {
            this.tokenCustomizer.customize((OAuth2TokenContext)jwtContext);
        }
        JwsHeader headers = headersBuilder.build();
        JwtClaimsSet claims = claimBuilder.build();
        return this.jwtEncoder.encode(JwtEncoderParameters.from((JwsHeader)headers, (JwtClaimsSet)claims));
    }

    private OAuthToken convertToken(Jwt jwt) {
        OAuthToken token = new OAuthToken();
        token.setAccessToken(jwt.getTokenValue());
        token.setTokenType(OAuth2AccessToken.TokenType.BEARER.getValue());
        if (jwt.getExpiresAt() == null) {
            token.setExpiresIn(Long.valueOf(-1L));
        } else {
            long expiresIn = ChronoUnit.SECONDS.between(Instant.now(), jwt.getExpiresAt());
            token.setExpiresIn(Long.valueOf(expiresIn));
        }
        token.setScope(Collections.emptySet());
        token.setRefreshToken(null);
        return token;
    }

    private Duration cachePrincipalDuration() {
        if (this.authorizationProperties.getTokenTtl() != null && this.authorizationProperties.getTokenTtl().getSeconds() > 0L) {
            return this.authorizationProperties.getTokenTtl();
        }
        return null;
    }
}

