/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.grant.email_code;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.email_code.EmailCodeAuthenticationToken;
import com.elitescloud.cloudt.core.verifycode.VerifyCodeManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class EmailCodeAuthenticationProvider
extends AbstractCustomAuthenticationProvider<EmailCodeAuthenticationToken> {
    private VerifyCodeManager verifyCodeManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(EmailCodeAuthenticationToken authentication) throws AuthenticationException {
        GeneralUserDetails user;
        String email = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)email)) {
            throw new AuthorizationException("\u90ae\u7bb1\u4e3a\u7a7a");
        }
        String code = (String)authentication.getCredentials();
        if (!StringUtils.hasText((String)code)) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (authentication.isAutoRegister() && !this.configProperties.getLogin().getAutoRegister().booleanValue()) {
            throw new AuthorizationException("\u4e0d\u652f\u6301\u81ea\u52a8\u6ce8\u518c\u8d26\u53f7");
        }
        String failMsg = this.verifyCodeManager.verify("cloudt_auth_login", email, code);
        if (failMsg != null) {
            throw new AuthorizationException("\u90ae\u7bb1\u9519\u8bef\u6216\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        GeneralUserDetails generalUserDetails = user = authentication.isAutoRegister() ? this.userDetailManager.registerOnLoadUserByEmailNotFound(email) : this.userDetailManager.loadUserByEmail(email);
        if (user == null) {
            throw new AuthorizationException("\u90ae\u7bb1\u9519\u8bef\u6216\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        return user;
    }

    @Autowired
    public void setVerifyCodeManager(VerifyCodeManager verifyCodeManager) {
        this.verifyCodeManager = verifyCodeManager;
    }
}

