/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_pwd;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.mobile_pwd.MobilePasswordAuthenticationToken;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class MobilePasswordAuthenticationProvider
extends AbstractCustomAuthenticationProvider<MobilePasswordAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(MobilePasswordAuthenticationProvider.class);

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(MobilePasswordAuthenticationToken authentication) throws AuthenticationException {
        String mobile = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)mobile)) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        GeneralUserDetails user = this.userDetailManager.loadUserByMobile(mobile);
        if (user == null) {
            throw new AuthorizationException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return user;
    }

    @Override
    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, MobilePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (!this.credentialCheckable.needCheck(authentication, userDetails)) {
            return;
        }
        if (authentication.getCredentials() == null) {
            log.debug("Failed to authenticate since no credentials provided");
            throw new BadCredentialsException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            log.debug("Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException("\u624b\u673a\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }
}

