/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.grant.password;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.provider.provider.LoginSupportProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.AbstractCustomAuthenticationProvider;
import com.elitescloud.cloudt.authorization.api.provider.security.grant.password.UsernamePasswordAuthenticationToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class UsernamePasswordAuthenticationProvider
extends AbstractCustomAuthenticationProvider<UsernamePasswordAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(UsernamePasswordAuthenticationProvider.class);
    @Autowired
    private LoginSupportProvider loginSupportManager;

    @Override
    @NonNull
    protected GeneralUserDetails retrieveUser(UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String username = (String)authentication.getPrincipal();
        if (!StringUtils.hasText((String)username)) {
            throw new AuthorizationException("\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        this.checkCaptcha(authentication);
        GeneralUserDetails user = this.userDetailManager.loadUserByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return user;
    }

    @Override
    protected void additionalAuthenticationChecks(GeneralUserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (!this.credentialCheckable.needCheck(authentication, userDetails)) {
            return;
        }
        if (authentication.getCredentials() == null) {
            log.debug("Failed to authenticate since no credentials provided");
            throw new BadCredentialsException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            log.debug("Failed to authenticate since password does not match stored value");
            throw new BadCredentialsException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkCaptcha(UsernamePasswordAuthenticationToken authentication) {
        Boolean need = authentication.getCaptchaNeeded();
        if (need != null && !need.booleanValue()) {
            return;
        }
        ApiResult<Boolean> verifyResult = this.loginSupportManager.verifyCaptcha(authentication.getCaptchaKey(), authentication.getCaptchaText());
        if (!verifyResult.isSuccess()) {
            throw new AuthorizationException(verifyResult.getMsg());
        }
        if (verifyResult.getData() == null || !((Boolean)verifyResult.getData()).booleanValue()) {
            throw new AuthorizationException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }
}

