/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.common.LoginMethodEnum;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.threadpool.ThreadPoolHolder;
import com.elitescloud.cloudt.context.util.DesensitizeUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.config.log.config.LogProperties;
import com.elitescloud.cloudt.core.config.log.model.bo.LoginLogBO;
import com.elitescloud.cloudt.core.config.log.queue.LogEvent;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.lmax.disruptor.RingBuffer;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public class LoginLogHandler {
    private static final Logger log = LogManager.getLogger(LoginLogHandler.class);
    private final RingBuffer<LogEvent> ringBuffer;
    private final LogProperties logProperties;
    private final Executor executor;

    public LoginLogHandler(RingBuffer<LogEvent> ringBuffer, LogProperties logProperties) {
        this.ringBuffer = ringBuffer;
        this.logProperties = logProperties;
        this.executor = this.createExecutor();
    }

    public void loginLog(HttpServletRequest request, Authentication authentication, Throwable throwable) {
        ((CompletableFuture)this.createLoginLog(request, authentication, throwable).thenAccept(this::addToQueue)).exceptionally(e -> {
            log.error("\u8bb0\u5f55\u767b\u5f55\u65e5\u5fd7\u5f02\u5e38\uff1a", e);
            return null;
        });
    }

    private CompletableFuture<LoginLogBO> createLoginLog(HttpServletRequest request, Authentication authentication, Throwable throwable) {
        LocalDateTime now = LocalDateTime.now();
        return CompletableFuture.supplyAsync(() -> {
            LoginLogBO logBO = new LoginLogBO();
            LocalDateTime loginTime = (LocalDateTime)request.getAttribute("cloudtLoginStartTime");
            ApiResult tokenResult = (ApiResult)request.getAttribute("cloudtLoginResult");
            logBO.setRequestTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)loginTime, (Object)now));
            logBO.setResponseTime(now);
            if (tokenResult != null && tokenResult.getData() != null) {
                logBO.setToken(((OAuthToken)tokenResult.getData()).getAccessToken());
            }
            logBO.setUserAgent(request.getHeader("User-Agent"));
            logBO.setMethod(request.getMethod());
            logBO.setReqContentType(request.getContentType());
            logBO.setUri(request.getRequestURI());
            logBO.setOperation("\u7528\u6237\u767b\u5f55");
            logBO.setReqIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            logBO.setReqOuterIp(request.getRemoteAddr());
            logBO.setQueryParams(request.getQueryString());
            MultiValueMap requestBody = HttpServletUtil.getFormParameters((HttpServletRequest)request);
            this.desensitizeRequestBody((MultiValueMap<String, String>)requestBody);
            logBO.setRequestBody(List.of(this.normalizeRequestBody((MultiValueMap<String, String>)requestBody)));
            if (tokenResult != null) {
                logBO.setResultCode(Integer.valueOf(tokenResult.getCode()));
                logBO.setMsg(tokenResult.getMsg());
                logBO.setResult((Object)tokenResult);
            }
            logBO.setThrowable(throwable);
            if (authentication != null && authentication instanceof AbstractCustomAuthenticationToken) {
                logBO.setLoginMethod(LoginMethodEnum.INNER.name());
            }
            logBO.setLoginType((String)requestBody.getFirst((Object)"login_type"));
            logBO.setTerminal((String)requestBody.getFirst((Object)"terminal"));
            if (this.logProperties.getLoginLog().getUserDetail().booleanValue() && authentication != null && authentication.getPrincipal() instanceof GeneralUserDetails) {
                logBO.setUserDetailObj(authentication.getPrincipal());
            }
            return logBO;
        }, this.executor);
    }

    private void desensitizeRequestBody(MultiValueMap<String, String> body) {
        List mobiles;
        if (body.isEmpty()) {
            return;
        }
        List passwords = (List)body.get((Object)"password");
        if (!CollectionUtils.isEmpty((Collection)passwords)) {
            passwords = passwords.stream().map(DesensitizeUtil::password).collect(Collectors.toList());
            body.put((Object)"password", passwords);
        }
        if (!CollectionUtils.isEmpty((Collection)(mobiles = (List)body.get((Object)"mobile")))) {
            mobiles = mobiles.stream().map(DesensitizeUtil::mobile).collect(Collectors.toList());
            body.put((Object)"mobile", mobiles);
        }
    }

    private Map<String, Object> normalizeRequestBody(MultiValueMap<String, String> body) {
        HashMap<String, Object> result = new HashMap<String, Object>(body.size());
        for (Map.Entry entry : body.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) {
                result.put((String)entry.getKey(), null);
                continue;
            }
            if (((List)entry.getValue()).size() == 1) {
                result.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(LoginLogBO logBO) {
        long msgSequence = this.ringBuffer.next();
        try {
            ((LogEvent)this.ringBuffer.get(msgSequence)).setLog((Object)logBO);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u767b\u5f55\u65e5\u5fd7\u5230\u961f\u5217\u65f6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            this.ringBuffer.publish(msgSequence);
        }
    }

    private Executor createExecutor() {
        LogProperties.ThreadPool threadPool = this.logProperties.getThreadPool();
        return ThreadPoolHolder.createThreadPool((String)threadPool.getThreadNamePrefix(), (Integer)threadPool.getCoreSize(), (Integer)threadPool.getMaxSize());
    }
}

