/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.token.AbstractCustomAuthenticationToken;
import com.elitescloud.cloudt.authorization.api.provider.config.system.ConfigProperties;
import com.elitescloud.cloudt.authorization.api.provider.security.AuthenticationCheckService;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.List;
import org.springframework.security.core.AuthenticationException;

public class DefaultAuthenticationCheckServiceImpl<T extends AbstractCustomAuthenticationToken<T>>
implements AuthenticationCheckService<T> {
    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public DefaultAuthenticationCheckServiceImpl(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    @Override
    public void additionalAuthenticationChecks(GeneralUserDetails userDetails, T authentication) throws AuthenticationException {
        this.validTerminal(userDetails, authentication);
    }

    private void validTerminal(GeneralUserDetails userDetails, T authentication) {
        Boolean terminalEnabled = this.configProperties.getLogin().getTerminalLimit();
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)terminalEnabled, (Object)false)).booleanValue()) {
            return;
        }
        Terminal terminal = authentication.getTerminal();
        if (terminal == null) {
            throw new AuthorizationException("\u672a\u8bbe\u7f6e\u767b\u5f55\u7ec8\u7aef");
        }
        List terminals = userDetails.getUser().getTerminals();
        if (terminals == null || terminals.isEmpty()) {
            throw new AuthorizationException("\u65e0\u6743\u9650\u767b\u5f55\u8be5\u7ec8\u7aef");
        }
        if (!terminals.contains(terminal)) {
            throw new AuthorizationException("\u65e0\u6743\u9650\u767b\u5f55\u8be5\u7ec8\u7aef");
        }
    }
}

