/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.security.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.provider.AuthenticationService;
import com.elitescloud.cloudt.authorization.api.provider.security.handler.LogoutRedirectHandler;
import com.elitescloud.cloudt.authorization.api.provider.security.listener.HttpSessionHolder;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class DefaultAuthenticationService
implements AuthenticationService {
    private static final Logger log = LogManager.getLogger(DefaultAuthenticationService.class);
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private final DelegateAuthenticationCallable authenticationCallable;
    private final LogoutRedirectHandler logoutRedirectHandler;

    public DefaultAuthenticationService(DelegateAuthenticationCallable authenticationCallable, LogoutRedirectHandler logoutRedirectHandler) {
        this.authenticationCallable = authenticationCallable;
        this.logoutRedirectHandler = logoutRedirectHandler;
    }

    @Override
    public ApiResult<String> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = SecurityContextUtil.currentToken();
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        String redirectUrl = request.getParameter("redirectUrl");
        if (CharSequenceUtil.isBlank((CharSequence)redirectUrl)) {
            redirectUrl = this.logoutRedirectHandler == null ? null : this.logoutRedirectHandler.determineUrlToUseForThisRequest(request, response);
        }
        String username = null;
        if (StringUtils.hasText((String)token) && user != null) {
            username = user.getUsername();
        }
        this.clearSession(request, response);
        this.authenticationCallable.onLogout(request, response, token, (Object)user);
        if (StringUtils.hasText((String)redirectUrl)) {
            try {
                response.sendRedirect(redirectUrl);
                return null;
            }
            catch (IOException e) {
                log.error(redirectUrl + "\u91cd\u5b9a\u5411\u5f02\u5e38\uff1a", (Throwable)e);
                return ApiResult.fail();
            }
        }
        return ApiResult.ok((Object)username);
    }

    @Override
    public ApiResult<GeneralUserDetails> currentUser() {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        user.getUser().setPassword("");
        return ApiResult.ok((Object)user);
    }

    private void clearSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = null;
        String customSessionId = CharSequenceUtil.blankToDefault((CharSequence)request.getParameter("X-Auth-SID"), (String)request.getHeader("X-Auth-SID"));
        if (StringUtils.hasText((String)customSessionId) && (session = HttpSessionHolder.getSession(customSessionId)) != null) {
            session.invalidate();
        }
        if ((session = request.getSession(false)) != null) {
            session.invalidate();
        }
        SecurityContext context = SecurityContextHolder.getContext();
        SecurityContextHolder.clearContext();
        context.setAuthentication(null);
    }
}

