/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.sso.impl;

import com.elitescloud.cloudt.authorization.api.provider.provider.rmi.system.RmiSysUserRpcService;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.ticket.TicketGenerator;
import com.elitescloud.cloudt.authorization.api.provider.sso.SsoLoginSupportProvider;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.sso.common.SsoAccountType;
import com.elitescloud.cloudt.authorization.sdk.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.authorization.sdk.util.AuthorizationServerHelper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class CloudtSsoLoginSupportProviderImpl
implements SsoLoginSupportProvider {
    private static final Logger log = LogManager.getLogger(CloudtSsoLoginSupportProviderImpl.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final TicketGenerator ticketGenerator;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private AuthorizationServerHelper authorizationServerHelper = AuthorizationServerHelper.getInstance();

    public CloudtSsoLoginSupportProviderImpl(AuthorizationSdkProperties sdkProperties, TicketGenerator ticketGenerator, RmiSysUserRpcService rmiSysUserRpcService) {
        this.sdkProperties = sdkProperties;
        this.ticketGenerator = ticketGenerator;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
    }

    @Override
    public ApiResult<String> generateTicket(String account, String accountType) {
        SsoAccountType ssoAccountType = null;
        try {
            ssoAccountType = SsoAccountType.valueOf((String)accountType);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b\uff1a" + accountType));
        }
        SysUserDTO user = null;
        try {
            user = this.queryUser(account, ssoAccountType);
        }
        catch (Exception e) {
            log.info("\u672a\u67e5\u8be2\u5230\u7528\u6237\uff1a{}\uff0c{}\uff0c{}", (Object)accountType, (Object)account, (Object)e.getMessage());
        }
        String ticket = null;
        if (user != null) {
            ticket = this.ticketGenerator.generate(user);
        }
        return ApiResult.ok(ticket);
    }

    @Override
    public ApiResult<UserInfoDTO> getUserInfo(String ticket) {
        if (!StringUtils.hasText((String)ticket)) {
            return ApiResult.fail((String)"ticket\u4e3a\u7a7a");
        }
        UserInfoDTO user = this.ticketGenerator.validate(ticket);
        return ApiResult.ok((Object)user);
    }

    private SysUserDTO queryUser(String account, SsoAccountType accountType) {
        switch (accountType) {
            case USER_ID: {
                return (SysUserDTO)this.rmiSysUserRpcService.getUserById(account).getData();
            }
            case USER_NAME: {
                return (SysUserDTO)this.rmiSysUserRpcService.getUserByUsername(account).getData();
            }
            case MOBILE: {
                return (SysUserDTO)this.rmiSysUserRpcService.getUserByMobile(account).getData();
            }
            case EMAIL: {
                return (SysUserDTO)this.rmiSysUserRpcService.getUserByEmail(account).getData();
            }
        }
        return (SysUserDTO)this.rmiSysUserRpcService.getUserByUsername(account).getData();
    }
}

