/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.provider.sso.impl;

import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationException;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.authorization.api.provider.security.generator.token.TokenGenerator;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.model.OAuthToken;
import com.elitescloud.cloudt.authorization.sdk.sso.SsoProvider;
import com.elitescloud.cloudt.authorization.sdk.sso.common.SsoAccountType;
import com.elitescloud.cloudt.authorization.sdk.sso.common.TicketAuthentication;
import com.elitescloud.cloudt.authorization.sdk.sso.model.UserInfoDTO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.io.Serializable;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class CloudtSsoProviderImpl
implements SsoProvider {
    private static final Logger log = LogManager.getLogger(CloudtSsoProviderImpl.class);
    private final TokenGenerator tokenGenerator;
    private final AuthenticationCache authenticationCache;
    private final UserDetailManager userDetailManager;
    private final RedisHelper redisHelper;
    private BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();
    private AuthorizationSdkProperties sdkProperties;
    private DelegateAuthenticationCallable authenticationCallable;

    public CloudtSsoProviderImpl(TokenGenerator tokenGenerator, AuthenticationCache authenticationCache, UserDetailManager userDetailManager, RedisHelper redisHelper) {
        this.tokenGenerator = tokenGenerator;
        this.authenticationCache = authenticationCache;
        this.userDetailManager = userDetailManager;
        this.redisHelper = redisHelper;
    }

    public boolean isAuthenticated(HttpServletRequest request) {
        String token = this.bearerTokenResolver.resolve(request);
        return this.authenticationCache.getUserDetail(token) != null;
    }

    public TicketAuthentication authentication(HttpServletRequest request, HttpServletResponse response, TicketAuthentication authentication) throws AuthenticationException {
        TicketAuthentication authenticationToken = this.validateAuthentication(authentication);
        OAuthToken authToken = this.tokenGenerator.generate((Authentication)authenticationToken);
        authenticationToken.setToken((Serializable)authToken);
        try {
            this.redisHelper.execute(redisUtils -> {
                redisUtils.set("cloudt:token:sso:" + authentication.getTicket(), (Object)authToken.getAccessToken());
                return null;
            });
            this.authenticationCallable.onLogin(request, response, authToken.getAccessToken(), (Authentication)authenticationToken);
        }
        catch (Exception e) {
            log.error("\u5355\u70b9\u767b\u5f55\u4fdd\u5b58token\u4e0eticket\u5173\u8054\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u751f\u6210token\u5931\u8d25", e);
        }
        return authenticationToken;
    }

    public void clearToken(HttpServletRequest request, HttpServletResponse response, String ticket) {
        String token = null;
        try {
            token = (String)this.redisHelper.execute(redisUtils -> redisUtils.get("cloudt:token:sso:" + ticket));
        }
        catch (Exception e) {
            log.error("\u5355\u70b9\u767b\u5f55\u83b7\u53d6token\u4e0eticket\u5173\u8054\u5931\u8d25", (Throwable)e);
            throw new IllegalStateException("\u83b7\u53d6token\u5931\u8d25", e);
        }
        if (StringUtils.hasText((String)token)) {
            try {
                this.redisHelper.execute(redisUtils -> {
                    redisUtils.del(new String[]{"cloudt:token:sso:" + ticket});
                    return null;
                });
            }
            catch (Exception e) {
                log.error("\u5355\u70b9\u767b\u5f55\u83b7\u53d6token\u4e0eticket\u5173\u8054\u5931\u8d25", (Throwable)e);
            }
            try {
                this.authenticationCache.removeUserDetail(token);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u7528\u6237token\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void setBearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    public void setSdkProperties(AuthorizationSdkProperties sdkProperties) {
        this.sdkProperties = sdkProperties;
    }

    public void setAuthenticationCallable(DelegateAuthenticationCallable authenticationCallable) {
        this.authenticationCallable = authenticationCallable;
    }

    private TicketAuthentication validateAuthentication(TicketAuthentication authentication) {
        SsoAccountType accountType = null;
        if (this.sdkProperties != null) {
            accountType = this.sdkProperties.getSso().getAccountType();
        }
        if (accountType == null) {
            accountType = SsoAccountType.USER_NAME;
        }
        UserInfoDTO userInfoDTO = authentication.getUserInfoDTO();
        GeneralUserDetails userDetails = null;
        switch (accountType) {
            case USER_ID: {
                userDetails = this.userDetailManager.loadUserById(userInfoDTO.getUserId());
                break;
            }
            case USER_NAME: {
                userDetails = this.userDetailManager.loadUserByUsername(userInfoDTO.getUsername());
                break;
            }
            case MOBILE: {
                userDetails = this.userDetailManager.loadUserByMobile(userInfoDTO.getMobile());
                break;
            }
            case EMAIL: {
                userDetails = this.userDetailManager.loadUserByEmail(userInfoDTO.getEmail());
            }
        }
        if (userDetails == null) {
            throw new AuthorizationException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        TicketAuthentication authenticationToken = new TicketAuthentication(authentication.getTicket(), userInfoDTO, Collections.emptyList());
        authenticationToken.setPrincipal((Object)userDetails);
        return authenticationToken;
    }
}

