package com.elitescloud.cloudt.authorization.sdk.cas.model;

import com.elitescloud.cloudt.authorization.sdk.cas.common.IdType;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 用户账号.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/6
 */
public class AuthUserDTO implements Serializable {
    private static final long serialVersionUID = 4079796814789885618L;

    /**
     * 用户账号ID，存在时则更新
     */
    private Long id;

    /**
     * 用户账号
     */
    @NotBlank(message = "账号不能为空")
    private String username;

    /**
     * 用户密码
     * <p>
     * 编辑用户时，传入新值则修改密码，否则密码不变
     */
    private String password;

    /**
     * 用户姓氏
     */
    private String lastName;

    /**
     * 用户名字
     */
    private String firstName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;

    /**
     * 密码过期时间
     */
    private LocalDateTime passwordExpiredTime;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 是否启用，默认是
     */
    private Boolean enabled;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 证件类型
     * {@link IdType}
     */
    private IdType idTypes;

    /**
     * 证件号码
     */
    private String idNum;

    /**
     * 备注
     */
    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public LocalDateTime getPasswordExpiredTime() {
        return passwordExpiredTime;
    }

    public void setPasswordExpiredTime(LocalDateTime passwordExpiredTime) {
        this.passwordExpiredTime = passwordExpiredTime;
    }

    public LocalDateTime getExpiredTime() {
        return expiredTime;
    }

    public void setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public IdType getIdTypes() {
        return idTypes;
    }

    public void setIdTypes(IdType idTypes) {
        this.idTypes = idTypes;
    }

    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
